#ifndef __CHANNELPAGE_H__
#define __CHANNELPAGE_H__

#include <qlined.h> 
#include <qbuttongroup.h> 
#include "ircChannel.h"
#include "ircPopup.h"
#include "ircListBox.h"
#include "outputPage.h"

class IrcClient;
class ControlButton;
class ChannelPage;

class CtrButton : public QWidget
{
  Q_OBJECT
protected:
  IrcChannel*  mChannel;
  IrcClient*   mClient;
  ChannelPage* mChannelPage;
protected slots:
  void opClicked();
  void voiceClicked();
  void kickClicked();
  void banClicked();
  void configClicked();
public:
  CtrButton(ChannelPage* c, QWidget* p=0L, const char* name=0L);
  ~CtrButton(){}

};

class ChannelPage : public OutputPage
{
  Q_OBJECT
  friend class IrcMDI;
  friend class CtrButton;
protected:
  IrcListBox* nickListBox;
  IrcChannel* chanClient;
  CtrButton*  ctrButton;
protected:
  void Init();
  void createPopup();
  void createMenu();
  void createToolbar();
  void createControlButton();
  virtual bool eventFilter(QObject *, QEvent *e);
  virtual void resizeEvent(QResizeEvent* e);
public slots:
  void slotAddUser       (const char* Nick);
  void slotDelUser       (const char* Nick);
  void slotChangeUserMode(const char* Nick, const char* Mode);
  void slotChangeNick    (const char* Nick, const char* NewNick);
  void slotChannelPopup  (const char*, const QPoint&);
  void slotChannelPopupAction(const char*);
  void slotUserListPopup  (const QPoint&);
  void slotUserListPopupAction(const char*);

  void slotTopic     (const char* txt, const char* by);
  void slotModeMenu  (int id);
  void slotBanMenu   (int id);
  void slotTopicMenu (int id);
  void slotAddMode    (char c, const char* txt);
  void slotDelMode    (char c, const char* txt);
  virtual void slotExit(MDIWindow*);
  void slotModeLimit  ();

  void slotModePopup();
  void slotBanPopup();
  void slotTopicPopup();

  void slotToggleSelection(bool);
  void slotWriteMsg(int type, const char* txt, bool parse=true);
public:
  ChannelPage(IrcClient* Client, QWidget* parent, const char* Name=NULL);
  ~ChannelPage();
  IrcChannel* getClient();
protected:
  int idTbMode, idTbBan, idTbTopic, idTbSelection;
  int idModeP, idModeS, idModeM, idModeT, idModeI, idModeN, idModeK, idModeL;
  int idTopicSet, idTopicRequest, idTopicIs, idTopicBy;

  //QVBoxLayout* listLayout;
};

#endif 



