#ifndef _INETADDRESS_H
#define _INETADDRESS_H

#include <qstring.h>
#include <netinet/in.h>

class InetAddress
{
private:
  QString hostName;
  QString hostAddress;
  ulong   address;
  int     family;
private:
  void Init();
public:
  InetAddress();
  InetAddress(const char* hostName);
  InetAddress(ulong address); 
  ~InetAddress();
  bool    forHost(const char* host);
  bool    forHost(ulong address);
  QString getHostAddress();
  QString getHostName();
  ulong   getAddress();
  int     getFamily();
  QString toString();
};

#endif
