#include "ksimpledlg.h"

ksimpledialog :: ksimpledialog(QWidget *parent, const char *name, bool modal)
	: QDialog(parent,name,modal)
{
	label=new QLabel(this);
	if (name) setlabel(name);
	label->setMargin(5);
	label->resize(label->sizeHint());
//	label->show();
	textline=new KLined(this,"value");
	textline->setGeometry(0,label->height(),
		textline->width(),textline->height());
	okbutton=new QPushButton("OK",this);
	okbutton->setGeometry(0,label->height()+textline->height(),
		okbutton->width(),okbutton->height());
	connect(okbutton,SIGNAL(clicked()),SLOT(okpressed()));
	connect(textline,SIGNAL(returnPressed()),SLOT(okpressed()));
	textline->setFocus();
//	show();
}

void ksimpledialog :: okpressed()
{
	accept();
}

void ksimpledialog :: setvalue(const char *text)
{
	textline->setText(text);
}

void ksimpledialog :: setlabel(const char *text)
{
	label->setText(text);
}

void ksimpledialog :: resizeEvent(QResizeEvent *e)
{
	textline->setGeometry(0,label->height(),
		width(),textline->height());
	okbutton->setGeometry(0,label->height()+textline->height(),
		width(),okbutton->height());
}

