/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#ifndef __ADVANCEDDIALOG_H__
#define __ADVANCEDDIALOG_H__

#include "dhcp.h"
#include <qdialog.h>
#include <qpushbt.h>
#include <qlined.h>
#include <qlistbox.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qgroupbox.h>
#include <qradiobutton.h>
#include <kspinbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>

class advancedDialog : public QDialog
{
    Q_OBJECT
public:
    advancedDialog(scopeAddresses *sa, QWidget* parent, const char* name);
    virtual ~advancedDialog();
protected slots:
    void Help_Click();
    void OK_Click();
    void Cancel_Click();
private:
    scopeAddresses *sac;
protected:
     void init();
     void update();
     QString getIP(int a,const char *text);
     QString putIP(QString a, QString b, QString c, QString d);

     int tmpint;
     
     QString caption;
     // IP Address Pool
    int widthSize, buttonSize, domainSize;
    QGroupBox *Options_Box;

    QLabel *NetbiosDDServer_Label;
    QLineEdit *NetbiosDDServer_Edit;
    QLabel *NetbiosNodeType_Label;
    QComboBox *NetbiosNodeType_ComboBox;
    QLabel *NisDomain_Label;
    QLineEdit *NisDomain_Edit;
    QLabel *NisServers_Label;
    QLineEdit *NisServers_Edit;

    QLabel *DiplayManager_Label;
    QLineEdit *DiplayManager_Edit;
    QLabel *FontServers_Label;
    QLineEdit *FontServers_Edit;
    QLabel *NtpServers_Label;
    QLineEdit *NtpServers_Edit;
    QLabel *SwapServer_Label;
    QLineEdit *SwapServer_Edit;
    QLabel *ImpressServers_Label;
    QLineEdit *ImpressServers_Edit;
    QLabel *ResourceLocationServers_Label;
    QLineEdit *ResourceLocationServers_Edit;
    QLabel *LprServers_Label;
    QLineEdit *LprServers_Edit;
    QLabel *CookieServers_Label;
    QLineEdit *CookieServers_Edit;
    QLabel *LogServers_Label;
    QLineEdit *LogServers_Edit;
    QLabel *Ien116NameServers_Label;
    QLineEdit *Ien116NameServers_Edit;
    QLabel *TimeServers_Label;
    QLineEdit *TimeServers_Edit;

    QPushButton *Ok_Button, *Cancel_Button, *Help_Button;
};

#endif
