/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "bind.h"
#include "setupDialog.h"
#include "askfordirectorydlg.h"

#include <qfileinfo.h>
#include <qdir.h>
#include <qmessagebox.h>

void KBindWidget::init()
{

  kc = kapp->getConfig();
  kc->setGroup("General");

  if(kc->readEntry("Bind81Write", 0) == 0) 
    {
      setupDialog *set = new setupDialog(this, "setup");
      set->show();
    }

  if(kc->readEntry("Bind81Write", 0) != "0" && kc->readEntry("Bind81Write", 0) != 0) 
    {
      bind81config_write = true;
    }

  if(kc->readEntry("Bind81Read", 0) != "0" && kc->readEntry("Bind81Read", 0) != 0) 
    {
      bind81config_read = true;
    }

  if(kc->readEntry("AutoReverseLookup", 0) != "0" &&
     kc->readEntry("AutoReverseLookup", 0) != 0)
    {
      auto_reverse_lookup = true;
    }

    parseboot();
    displaySettings();

  if(kc->readEntry("Status", 0) != "0" &&
     kc->readEntry("Status", 0) != 0) 
    {
      status_check = true;
      parselog();
    }

}

void KBindWidget::readStat()
{
  char tmp[255];
  QString st1;
  char tmp1[255];
  char *tok;
  bool s1,s2;
  int n = 0;
  printf("Parsing Status file ...\n");
  QFile *file = new QFile("/var/named/named.stats");
  if(bind81config_read) 
    {
      file->setName(*directory + "named.stats");
    }
  s1=false; s2=false;
  if (file->open(IO_ReadOnly)) 
    {
      statlist->setColumn(n++,"IP",80);
      file->readLine(tmp,255);
      if (strncmp(tmp,"+++",3) == 0) { s1=true; }
      if (strncmp(tmp,"++ ",3) == 0) { s2=true; }
      if (s1) 
	{
	  do 
	    {
	      file->readLine(tmp,255);
	      if ((strncmp(tmp,"+",1) != 0) && (strncmp(tmp, "<", 1) != 0))
		simplestatlist->insertItem(tmp);
	    } 
	  while ((strncmp(tmp,"++ ",3) != 0) && (strncmp(tmp, "<<", 2) != 0));
	  do 
	    {
	      file->readLine(tmp,255);
	      // printf("S2 : %s\n",tmp);
	      if (strncmp(tmp,"(Legend)",8) == 0) 
		{
		  file->readLine(tmp,255);
		  do 
		    {
		      tok=strtok(tmp," \t");
		      do 
			{
			  statlist->setColumn(n++,tok,50);
			  tok=strtok(0," \t");
			} 
		      while (strlen(tok) > 0);
		      file->readLine(tmp,255);
		    } 
		  while (strncmp(tmp,"(",1) != 0);
		  
		  file->readLine(tmp1,255);
		  st1=tmp;
		  st1.remove(0,1);
		  st1.remove(st1.length()-2,2);		
		  st1=st1+" "+tmp1;
		  st1=st1.simplifyWhiteSpace();
		  statlist->appendItem(st1);
		} 
	      else if (strncmp(tmp,"-",1) != 0) 
		{
		  // Parse the hosts ..
		  file->readLine(tmp1,255);
		  st1=tmp;
		  st1.remove(0,1);
		  st1.remove(st1.length()-2,2);		
		  st1=st1+" "+tmp1;
		  st1=st1.simplifyWhiteSpace();
		  statlist->appendItem(st1);
		}
	    } 
	  while (strncmp(tmp,"--",2) !=0 );
	      s1=false;
	} 
    } 
  else 
    {
      printf("No Status information found !\n");
    }
}

void KBindWidget::parseboot()
{
  char tmp[70000];
  QString st,st1,st2, st3;
  PrimaryDomain *pl;
  secondaryDomain *sl;
  int s1, s2, s3, times;
  QFileInfo checkWritePermFileInfo;
  QDir dbDir;

  if(bind81config_read) 
    {
      QFile configFile( "/etc/named.conf" );
      QString configData, currentRow;
      QList< QString > parameterList;
      QString *parameterListItemToRemove;
      int i, i2;

      parameterList.setAutoDelete( TRUE );      
      configFile.open( IO_ReadOnly );
      configFile.readBlock( tmp, configFile.size() );
      configFile.close();
      configData = tmp;
      while ( configData.find( '\t' ) != -1 ) //replace all tabs with whitespace.
	{
	  i = configData.find( '\t' );
	  configData.replace( i, 1, " " );
	}
      
      while ( configData.find( "//" ) != -1 ) // Remove these //
	{
	  i = configData.find( "//" );
	  i2 = configData.find( '\n', i);
	  configData.remove(i, (i2-i));
	}

      while ( configData.find( '#' ) != -1 ) // Remove these #
	{
	  i = configData.find( '#' );
	  i2 = configData.find( '\n', i);
	  configData.remove(i, (i2-i));
	}

      while ( configData.find( "/*" ) != -1 ) // Remove these /* */
	{
	  i = configData.find( "/*" );
	  i2 = configData.find( "*/", i);
	  configData.remove(i, (i2-i+2));
	}
      
      while ( configData.find( ';' ) != -1 ) // Remove this ;
	{
	  i = configData.find( ';' );
	  configData.remove(i, 1);
	}

      while ( configData.find( '\"' ) != -1 ) // Remove this "
	{
	  i = configData.find( '\"' );
	  configData.remove(i, 1);
	}

      s1 = configData.find("}");
      s2 = configData.find("{");
      s2 = configData.find("{",s2);
      if(s2>s1)
	{
	  times = 1;
	  while(times != 0 && s1 != -1)
	    {
	      s3 = s1;
	      s1 = configData.find("}",(s3+1));
	      s2 = configData.find("{",(s3+1));
	      if(s2>s1) --times;
	    }
	}
      currentRow = ( const char * ) configData.left( configData.find( "\n}" ) + 2 );
      configData = ( const char * ) configData.right( configData.length() - configData.find( "\n}" ) - 3 );
      currentRow = currentRow.simplifyWhiteSpace();
      for( i = 0; currentRow.find( " " ) != - 1; i++ )
	{
	  parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	  currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	}
      parameterList.append( new QString( ( const char * ) currentRow ) ); 

      while ( currentRow.isEmpty() != true )
	{
	  if ( strcmp( ( const char * ) *parameterList.first(), "options" ) == 0 )
	    {
	      QString *tmp = parameterList.next();
	      while ( tmp != 0 )
		{
		  if (strcmp( ( const char * ) *tmp, "{" ) == 0 )
		    {
		    }
		  else if ( strcmp( ( const char * ) *tmp, "directory" ) == 0 )
		    {
		      tmp = parameterList.next();
		      *directory = ( const char * ) *tmp;
		      *directory = directory->left(directory->length());
		    }
		  else if ( strcmp( ( const char * ) *tmp, "dump-file" ) == 0 )
		    {
		      tmp = parameterList.next();
		      *dump = ( const char * ) *tmp;
		      *dump = dump->left(dump->length());
		    }
		  else if ( strcmp( ( const char * ) *tmp, "pid-file" ) == 0 )
		    {
		      tmp = parameterList.next();
		      *pid = ( const char * ) *tmp;
		      *pid = pid->left(pid->length());
		    }
		  else if ( strcmp( ( const char * ) *tmp, "statistics-file" ) == 0 )
		    {
		      tmp = parameterList.next();
		      *statistics = ( const char * ) *tmp;
		      *statistics = statistics->left(statistics->length());
		    }
		  else if ( strcmp( ( const char * ) *tmp, "memstatistics-file" ) == 0 )
		    {
		      tmp = parameterList.next();
		      *memstatistics = ( const char * ) *tmp;
		      *memstatistics = memstatistics->left(memstatistics->length());
		    }
		  else if ( strcmp( ( const char * ) *tmp, "named-xfer" ) == 0 )
		    {
		      tmp = parameterList.next();
		      *namedxfer = ( const char * ) *tmp;
		      *namedxfer = namedxfer->left(namedxfer->length());
		    }
		  else if ( strcmp( ( const char * ) *tmp, "check-names" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if ( strcmp( ( const char * ) *tmp, "master" ) == 0 )
			{
			  tmp = parameterList.next();
			  if ( strcmp( ( const char * ) *tmp, "fail" ) == 0 )			    
			    checkNamePrimaryComboBox->setCurrentItem( 1 );			    
			  else if ( strcmp( ( const char * ) *tmp, "ignore" ) == 0 )			    
			    checkNamePrimaryComboBox->setCurrentItem( 2 );
			  else if ( strcmp( ( const char * ) *tmp, "warn" ) == 0 )			
			    checkNamePrimaryComboBox->setCurrentItem( 3 );			    
			}
		      else if ( strcmp( ( const char * ) *tmp, "slave" ) == 0 )
			{
			  tmp = parameterList.next();			  
			  if ( strcmp( ( const char * ) *tmp, "fail" ) == 0 )			   
			    checkNameSecondaryComboBox->setCurrentItem( 1 );			    
			  else if ( strcmp( ( const char * ) *tmp, "ignore" ) == 0 )		  
			    checkNameSecondaryComboBox->setCurrentItem( 2 );
			  else if ( strcmp( ( const char * ) *tmp, "warn" ) == 0 )
			    checkNameSecondaryComboBox->setCurrentItem( 3 );
			}
		      else if ( strcmp( ( const char * ) *tmp, "response" ) == 0 )
			{
			  tmp = parameterList.next();			  
			  if ( strcmp( ( const char * ) *tmp, "fail" ) == 0 )
			    checkNameResponseComboBox->setCurrentItem( 1 );
			  else if ( strcmp( ( const char * ) *tmp, "ignore" ) == 0 )
			    checkNameResponseComboBox->setCurrentItem( 2 );
			  else if ( strcmp( ( const char * ) *tmp, "warn" ) == 0 )
			    checkNameResponseComboBox->setCurrentItem( 3 );
			}
		      else
			{
			  tmp = parameterList.next();
			}
		    }
		  else if ( strcmp( ( const char * ) *tmp, "datasize" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitDataSizeEdit->setText( ( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "files" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitMaxFileHandlesEdit->setText( ( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "coresize" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitCoreSizeEdit->setText( ( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "stacksize" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitStackSizeEdit->setText( ( const char * ) *tmp); 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "transfer-format" ) == 0 )
		    {
		      tmp = parameterList.next();			  
		      if ( strcmp( ( const char * ) *tmp, "one-answer" ) == 0 )
			{
			  limitTransferFormatComboBox->setCurrentItem( 1 );
			}
		      else if ( strcmp( ( const char * ) *tmp, "many-answers" ) == 0 )
			{
			  limitTransferFormatComboBox->setCurrentItem( 2 );
			}
		      else
			{      
			  limitTransferFormatComboBox->setCurrentItem( 1 );
			}
		    }
		  else if ( strcmp( ( const char * ) *tmp, "cleaning-interval" ) == 0 )
		    {
		      tmp = parameterList.next();
		      intervalCleaningEdit->setText( ( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "interface-interval" ) == 0 )
		    {
		      tmp = parameterList.next();
		      intervalInterfaceEdit->setText( ( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "statistics-interval" ) == 0 )
		    {
		      tmp = parameterList.next();
		      intervalStatisticsEdit->setText( ( const char * ) *tmp); 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "transfers-in" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitTransfersInEdit->setText( ( const char * ) *tmp );
		    }
		  else if ( strcmp( ( const char * ) *tmp, "transfers-out" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitTransfersOutEdit->setText( ( const char * ) *tmp );
		    }
		  else if ( strcmp( ( const char * ) *tmp, "transfers-per-ns" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitTransfersPerNsEdit->setText( ( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "max-transfer-time-in" ) == 0 )
		    {
		      tmp = parameterList.next();
		      limitMaxTransferTimeInEdit->setText( ( const char * ) *tmp);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "fake-iquery" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(yes_no(( const char * ) *tmp)) fi_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "fetch-glue" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(!yes_no(( const char * ) *tmp)) nofg_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "recursion" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(!yes_no(( const char * ) *tmp)) nor_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "notify" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(!yes_no(( const char * ) *tmp)) non_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "multiple-cnames" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(yes_no(( const char * ) *tmp)) mc_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "host-statistics" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(yes_no(( const char * ) *tmp)) hs_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "deallocate-on-exit" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(yes_no(( const char * ) *tmp)) doe_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "auth-nxdomain" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(!yes_no(( const char * ) *tmp)) nan_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "forward" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if (strcmp((const char*)*tmp, "only") == 0) fo_check->setChecked(true);
		    }
		  else if ( strcmp( ( const char * ) *tmp, "forwarders" ) == 0 )
		    {
		      tmp = parameterList.next(); tmp = parameterList.next();
		      while ( strcmp(( const char * ) *tmp, "}" ) != 0 ) 
			{
			  forwarders->append( ( const char * ) *tmp );
			  tmp = parameterList.next();
			} 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "allow-transfer" ) == 0 )
		    {
		      tmp = parameterList.next(); tmp = parameterList.next();
		      while ( strcmp(( const char * ) *tmp, "}" ) != 0 ) 
			{			 			    
			  i = tmp->find( '/' );
			  tmp->remove(i,(tmp->length() - i));
			  xfrnets->append( ( const char * ) *tmp );
			  tmp = parameterList.next();
			} 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "allow-query" ) == 0 )
		    {
		      tmp = parameterList.next(); tmp = parameterList.next();
		      while ( strcmp(( const char * ) *tmp, "}" ) != 0 ) 
			{			 			    
			  /* DO SOMETHING */			    
			  tmp = parameterList.next();
			} 
		    }
		  else if (strcmp( ( const char * ) *tmp, "}" ) == 0 )
		    {
		    }
		  else
		    {
		      debug("Can't understand this (yet):");
		      debug(( const char * ) *tmp);
		    }
		  tmp = parameterList.next();
		}
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "zone" ) == 0 )
	    { 
	      QString *tmp2 = parameterList.next();
	      QString *tmp = parameterList.next();
	      if (strcmp( ( const char * ) *tmp, "{" ) == 0 )
		{
		}
	      else
		{
		  tmp = parameterList.next();
		}
	      tmp = parameterList.next();
	      while ( tmp != 0 )
		{
		  if  (strcmp( ( const char * ) *tmp, "type" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if  (strcmp( ( const char * ) *tmp, "master" ) == 0 )
			{
			  tmp = parameterList.next(); tmp = parameterList.next();
			  if(auto_reverse_lookup)
			    {
			      if ( strcmp( ( const char * ) tmp2->right( strlen( ".in-addr.arpa" ) ), ".in-addr.arpa" ) != 0 )			
			        {
			          pl = new PrimaryDomain( (const char*)*tmp2, (const char*)*tmp );
			          primaryList->append(pl); 			          
			        }
			    }
			  else
			    {			
			      pl = new PrimaryDomain( (const char*)*tmp2, (const char*)*tmp );
			      primaryList->append(pl);
			    }
			
			}
		      else if  (strcmp( ( const char * ) *tmp, "slave" ) == 0 )
			{
			  tmp = parameterList.next(); tmp = parameterList.next();
			  sl= new secondaryDomain();
			  sl->domain = ( const char * )*tmp2;
			  sl->ip = new QStrList();
			  sl->file=( const char * ) *tmp;
			  tmp = parameterList.next();			 			 
			  if (strcmp( ( const char * ) *tmp, "masters" ) == 0 )
			    {			      
			      tmp = parameterList.next(); tmp = parameterList.next();
			      while ( strcmp(( const char * ) *tmp, "}" ) != 0 ) 
				{				 		 
				  sl->ip->append((const char *)*tmp ); 
				  tmp = parameterList.next();
				} 
			    }
			  secondaryList->append(sl);
			}
		      
		      else if  (strcmp( ( const char * ) *tmp, "stub" ) == 0 )
			{
			}
		      else if  (strcmp( ( const char * ) *tmp, "hint" ) == 0 )
			{
			  tmp = parameterList.next();
			  tmp = parameterList.next();
			  *cache = ( const char * ) *tmp;
			  cacheedit->setText( ( const char * ) *cache );
			}
		    }
		  else if (strcmp( ( const char * ) *tmp, "}" ) == 0 )
		    {
		    }
		  else
		    {
		    }
		  tmp = parameterList.next();
		}
	    }
	   else if ( strcmp( ( const char * ) *parameterList.first(), "logging" ) == 0 )
	    {
	      QString *tmp = parameterList.next();
	      while ( tmp != 0 )
		{
		  if ( strcmp( ( const char * ) *tmp, "bogus" ) == 0 )
		    {
		    }
		  else
		    {
		    }
		  tmp = parameterList.next();
	        }
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "server" ) == 0 )
	    {
	      QString *tmp2 = parameterList.next();
	      QString *tmp = parameterList.next();
	      tmp = parameterList.next();
	      while ( tmp != 0 )
		{
		  if ( strcmp( ( const char * ) *tmp, "bogus" ) == 0 )
		    {
		      tmp = parameterList.next();
		      if(yes_no(( const char * ) *tmp)) bogusns->append( ( const char * ) *tmp2 );
		    }
		  tmp = parameterList.next();
		}
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "include" ) == 0 )
	    {
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "key" ) == 0 )
	    {
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "acl" ) == 0 )
	    {
	      QString *tmp = parameterList.next();
	      while ( tmp != 0 )
		{
		  tmp = parameterList.next();
	        }
	    }
	  for ( parameterListItemToRemove = parameterList.first(); //Clear the list.
		parameterListItemToRemove != 0;
		parameterListItemToRemove = parameterList.first() )
	    {
	      parameterList.remove( parameterListItemToRemove );
	    }
	  if(configData.find("}") > -1 )
	    {
	      s1 = configData.find("}");
	      s2 = configData.find("{");
	      if(configData.find("{",(s2+1)) != -1)
		{
		  s2 = configData.find("{",(s2+1));
		  if(s2>s1) {}
		  else
		    {
		      times = 1;
		      while(times != 0 && s1 != -1) //||
			{
			  s3 = s1;
			  s1 = configData.find("}",(s3+1));
			  s2 = configData.find("{",(s3+1));
			  if(s2>s1) --times;
			}
		    }
		  if(0 >= s1)
		    s1 = configData.length() - 2;
		}
		
	      currentRow = ( const char * ) configData.left((s1+1));
	      configData = ( const char * ) configData.right( configData.length() - (s1+2));
	      currentRow = currentRow.simplifyWhiteSpace();
	    }
	  else 
	    {
	      currentRow = 0;
	    }
	  for( i = 0; currentRow.find( " " ) != - 1; i++ )
	    {
	      parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	      currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	    }
	  parameterList.append( new QString( ( const char * ) currentRow ) );
	}
    
      // exit(0);
    } 
  else 
    {
      QFile configFile( "/etc/named.boot" );
      QString configData, currentRow;
      QList< QString > parameterList;
      QString *parameterListItemToRemove;
      int i;

      parameterList.setAutoDelete( TRUE );      
      configFile.open( IO_ReadOnly );
      configFile.readBlock( tmp, configFile.size() );
      configFile.close();
      configData = tmp;
            
      while ( configData.find( '\t' ) != -1 ) //replace all tabs with whitespace.
	{
	  i = configData.find( '\t' );
	  configData.replace( i, 1, " " );
	}

      currentRow = ( const char * ) configData.left( configData.find( "\n" ) + 1 );
      configData = ( const char * ) configData.right( configData.length() - configData.find( "\n" ) - 1 );
      currentRow = currentRow.simplifyWhiteSpace();
      
      for( i = 0; currentRow.find( " " ) != - 1; i++ )
	{
	  parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	  currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	}
      parameterList.append( new QString( ( const char * ) currentRow ) ); 

      while ( currentRow.isEmpty() != TRUE )
	{
	  if ( strcmp( ( const char * ) *parameterList.first(), "primary" ) == 0 )
	    {
	      //Omitting reverse-domains.
	      if(auto_reverse_lookup)
		{
	          if ( strcmp( ( const char * ) parameterList.at( 1 )->right( strlen( ".in-addr.arpa" ) ), ".in-addr.arpa" ) != 0 )
		    {
		      pl = new PrimaryDomain( *parameterList.at( 1 ), *parameterList.at( 2 ) );
		      primaryList->append(pl);        
		    }
		}
	      else
		{
		  pl = new PrimaryDomain( *parameterList.at( 1 ), *parameterList.at( 2 ) );
		  primaryList->append(pl);
		}
	    }
	  
	  else if ( strcmp( ( const char * ) *parameterList.first(), "secondary" ) == 0 )
	    {
	      sl= new secondaryDomain();
	      sl->domain = *parameterList.at( 1 );
	      sl->ip = new QStrList();
	      QString *tmp = parameterList.at( 1 );
	      while ( tmp != 0 ) 
		{
		  if ( isIP( ( const char * ) *tmp ) )
		    {
		      sl->ip->append(st2); 
		    } 
		  else 
		    {
		      sl->file=st2;
		    }
		  tmp = parameterList.next();
		}
	      secondaryList->append(sl);
	    }

	  else if ( strcmp( ( const char * ) *parameterList.first(), "directory" ) == 0 )
	    {
	      *directory = ( const char * ) *parameterList.at( 1 );
	      *directory = directory->left(directory->length());
	    }

	  else if ( strcmp( ( const char * ) *parameterList.first(), "cache" ) == 0 )
	    {
	      *cache = ( const char * ) *parameterList.at( 2 );
	      cacheedit->setText( ( const char * ) *cache );
	    }

	  else if ( strcmp( ( const char * ) *parameterList.first(), "forwarders" ) == 0 )
	    {
	      QString *tmp = parameterList.at( 1 );
	      while ( tmp != 0 ) 
		{
		  forwarders->append( ( const char * ) *tmp );
		  tmp = parameterList.next();
		}
	    }

	  else if ( strcmp( ( const char * ) *parameterList.first(), "xfrnets" ) == 0 )
	    {
	      QString *tmp = parameterList.at( 1 );
	      while ( tmp != 0 ) 
		{
		  xfrnets->append( ( const char * ) *tmp );
		  tmp = parameterList.next();
		}
	    }

	  else if ( strcmp( ( const char * ) *parameterList.first(), "bogusns" ) == 0 )
	    {
	      QString *tmp = parameterList.at( 1 );
	      while ( tmp != 0 ) 
		{
		  bogusns->append( ( const char * ) *tmp );
		  tmp = parameterList.next();
		}
	    }
	  
	  else if ( strcmp( ( const char * ) *parameterList.first(), "options" ) == 0 )
	    {
	      QString *tmp = parameterList.at( 1 );
	      while ( tmp != 0 ) 
		{
		  if ( strcmp( ( const char * ) *tmp, "forward-only" ) == 0 )
		    { 
		      options |= forward_only;
		      fo_check->setChecked(TRUE); 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "no-recursion" ) == 0 )
		    {
		      options |= no_recursion;
		      nor_check->setChecked(TRUE); 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "no-fetch-glue" ) == 0 )
		    {
		      options |= no_fetch_glue;
		      nofg_check->setChecked(true); 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "query-log" ) == 0 )
		    {
		      options |= query_log;
		      ql_check->setChecked(true); 
		    }
		  else if ( strcmp( ( const char * ) *tmp, "fake-iquery" ) == 0 )
		    {
		      options |= fake_iquery;
		      fi_check->setChecked(true); 
		    }
		  tmp = parameterList.next();
		}
	    }

	  else if ( strcmp( ( const char * ) *parameterList.first(), "check-names" ) == 0 )
	    {
	      if ( strcmp( ( const char * ) *parameterList.at( 1 ), "primary" ) == 0 )
		{
		  if ( strcmp( ( const char * ) *parameterList.at( 2 ), "fail" ) == 0 )
		    checkNamePrimaryComboBox->setCurrentItem( 1 );		    
		  else if ( strcmp( ( const char * ) *parameterList.at( 2 ), "ignore" ) == 0 )
		    checkNamePrimaryComboBox->setCurrentItem( 2 );		    
		  else if ( strcmp( ( const char * ) *parameterList.at( 2 ), "warn" ) == 0 )
		    checkNamePrimaryComboBox->setCurrentItem( 3 );		    
		}
	      else if ( strcmp( ( const char * ) *parameterList.at( 1 ), "secondary" ) == 0 )
		{
		  if ( strcmp( ( const char * ) *parameterList.at( 2 ), "fail" ) == 0 )		    
		    checkNameSecondaryComboBox->setCurrentItem( 1 );		    
		  else if ( strcmp( ( const char * ) *parameterList.at( 2 ), "ignore" ) == 0 )		    
		    checkNameSecondaryComboBox->setCurrentItem( 2 );		    
		  else if ( strcmp( ( const char * ) *parameterList.at( 2 ), "warn" ) == 0 )		    
		    checkNameSecondaryComboBox->setCurrentItem( 3 );		    
		}
	      else if ( strcmp( ( const char * ) *parameterList.at( 1 ), "response" ) == 0 )
		{
		  if ( strcmp( ( const char * ) *parameterList.at( 2 ), "fail" ) == 0 )		    
		      checkNameResponseComboBox->setCurrentItem( 1 );		    
		  else if ( strcmp( ( const char * ) *parameterList.at( 2 ), "ignore" ) == 0 )		    
		    checkNameResponseComboBox->setCurrentItem( 2 );		    
		  else if ( strcmp( ( const char * ) *parameterList.at( 2 ), "warn" ) == 0 )		    
		    checkNameResponseComboBox->setCurrentItem( 3 );		    
		}
	    }
	  else if ( strcmp( ( const char * ) *parameterList.first(), "limit" ) == 0 )
	    {
	      if ( strcmp( ( const char * ) *parameterList.at( 1 ), "datasize" ) == 0 )		
		limitDataSizeEdit->setText( ( const char * ) *parameterList.at( 2 ) );		
	      else if ( strcmp( ( const char * ) *parameterList.at( 1 ), "files" ) == 0 )	      
		limitMaxFileHandlesEdit->setText( ( const char * ) *parameterList.at( 2 ) );		
	      else if ( strcmp( ( const char * ) *parameterList.at( 1 ), "transfers-in" ) == 0 )
		limitTransfersInEdit->setText( ( const char * ) *parameterList.at( 2 ) );		
	      else if ( strcmp( ( const char * ) *parameterList.at( 1 ), "transfers-per-ns" ) == 0 )	       
		limitTransfersPerNsEdit->setText( ( const char * ) *parameterList.at( 2 ) );		
	    }

	  for ( parameterListItemToRemove = parameterList.first(); //Clear the list.
		parameterListItemToRemove != 0;
		parameterListItemToRemove = parameterList.first() )
	    {
	      parameterList.remove( parameterListItemToRemove );
	    }
	  currentRow = ( const char * ) configData.left( configData.find( "\n" ) + 1 );
	  configData = ( const char * ) configData.right( configData.length() - configData.find( "\n" ) - 1 );
	  currentRow = currentRow.simplifyWhiteSpace();
	  
	  for( i = 0; currentRow.find( " " ) != - 1; i++ )
	    {
	      parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	      currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	    }
	  parameterList.append( new QString( ( const char * ) currentRow ) ); 
	}
    }
  if ( directory->isEmpty() && primaryList->count() != 0 ) //No directory, but database should exist. Not good.
    {
      AskForDirectoryDlg afdDlg( directory,i18n( "There is no directory specification in /etc/named.conf.\nThis is essential to Kcmbind. You may enter a directory below, or quit" ), this );
      afdDlg.exec();
    }
  if ( !directory->isEmpty() && primaryList->count() != 0)
    {
      dbDir.setPath( ( const char * ) *directory );
      while (!dbDir.exists() && !dbDir.isReadable()) // Better than nothing ;)isReadable should be isWriteable, but now such function do exist!!
	{
         AskForDirectoryDlg afdDlg( directory,i18n( "The directory specified doesn't exist.\nThis is essential to Kcmbind. You may enter a directory below, or quit"), this );
         afdDlg.exec();
         dbDir.setPath( ( const char * ) *directory );
	}
      //And check if we are allowed to read the database.
      checkWritePermFileInfo.setFile( ( const char * ) *directory );
      while ( !checkWritePermFileInfo.isReadable() || !checkWritePermFileInfo.isExecutable() )
	{
	  switch( QMessageBox::critical( this, i18n("Kcmbind"), i18n("You must have both read and execute permission on the specified directory!" ), QMessageBox::Retry | QMessageBox::Default, QMessageBox::Abort ) )
	    {
	    case QMessageBox::Abort:
	      exit( 0 );
	    }
	}
    }
  for ( pl = primaryList->first();
	pl != 0;
	pl = primaryList->next() )
    {
      readSOA(pl, *directory + '/'+ pl->fileName);
    }
}

void KBindWidget::parselog()
{
  QFile *file = new QFile("/var/run/named.pid");
 
  if (!pid->isNull() )
    file->setName(*pid);
 
  if(file->open(IO_ReadOnly))
    {
	char tmp[255];
	int pid = 0;
	file->readLine(tmp,255);
	file->close();
	if(bind81config_read) 
	  {
	    printf("Removing old named.stats\n");
	    file->setName(*directory + "named.stats");
	    file->open(IO_Truncate | IO_WriteOnly);
	    file->close();
	    pid=atoi(tmp);
	    printf("Sending SIGILL to named (pid %u)\n",pid);
	    kill(pid,SIGILL);
	  }
	else
	  {
	    printf("Removing old named.stats\n");
	    file->setName("/var/tmp/named.stats");
	    file->open(IO_Truncate | IO_WriteOnly);
	    file->close();
	    pid=atoi(tmp);
	    printf("Sending SIGIOT to named (pid %u)\n",pid);
	    kill(pid,SIGIOT);
	  }
	usleep(1000000);
	// sleep one second to allow named to dump its data 
	sprintf(tmp,i18n("PID  of named : %u"),pid);
	tl->setText(tmp);
       	readStat();	       
    } 
  else 
    { tl->setText(i18n("PID of named not aviable!")); }    
  delete file;
}


void KBindWidget::displaySettings()
{
  PrimaryDomain *pl;
  secondaryDomain *sl;  
  cacheedit->setText(*cache);
  diredit->setText(*directory);
  dumpedit->setText(*dump);
  memstatisticsedit->setText(*memstatistics);
  pidedit->setText(*pid);
  statisticsedit->setText(*statistics);
  xferedit->setText(*namedxfer);


  plist->clear();
  slist->clear();
  xlist->clear();
  blist->clear();

  for (pl=primaryList->first();pl!=0;pl=primaryList->next()) {
    plist->insertItem(pl->domain);
    
  } 
  for (sl=secondaryList->first();sl!=0;sl=secondaryList->next()) {
    slist->insertItem(sl->domain);
    
  } 

  if (!forwarders->isEmpty())  flist->insertStrList(forwarders);  
  //  flist->insertStrList(forwarders);
  xlist->insertStrList(xfrnets); 
  blist->insertStrList(bogusns); 
}

int KBindWidget::readSOA(PrimaryDomain *pl, QString path)
{
  char tmp[5000];
  // char *tok;
  QString *st, *st1, *st2, *st3, *st4;

  QFile configFile( path );
  QString configData, currentRow;
  QList< QString > parameterList;
  QString *parameterListItemToRemove;
  int i, i2;
  record * helprecord;

  // This is moved to primarydomain.cpp!
  //pl->data = new (QList<record>);
  //pl->data->setAutoDelete(TRUE);

  parameterList.setAutoDelete( TRUE );      
  if(configFile.exists())
    {
      configFile.open( IO_ReadOnly );
      configFile.readBlock( tmp, 5000 );
      configFile.close();
      configData = tmp;
    }
  else
    {
      debug("File :"+path+" not FOUND!");
      return(0);
    }
  
  while ( configData.find( '\t' ) != -1 ) //replace all tabs with whitespace.
    {
      i = configData.find( '\t' );
      configData.replace( i, 1, " " );
    }
  
  while ( configData.find( '#' ) != -1 ) // Remove these #
    {
      i = configData.find( '#' );
      i2 = configData.find( '\n', i);
      configData.remove(i, (i2-i));
    }
      
  while ( configData.find( ';' ) != -1 ) // Remove this ;
    {
      i = configData.find( ';' );
      i2 = configData.find( '\n', i);
      configData.remove(i, (i2-i));
    }

  while ( configData.find( '$' ) != -1 ) // FOR NOW! Remove this $
    {
      i = configData.find( '$' );
      i2 = configData.find( '\n', i);
      configData.remove(i, (i2-i));
    }

  currentRow = ( const char * ) configData.left( configData.find( ")" ) + 1);
  configData = ( const char * ) configData.right( configData.length() - configData.find( ")" ) - 1 );
  currentRow = currentRow.simplifyWhiteSpace();


  for( i = 0; currentRow.find( " " ) != - 1; i++ )
    {
      parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
      currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
    }
  parameterList.append( new QString( ( const char * ) currentRow ) ); 
  st = parameterList.first();

  //SOA Record ///
  st = parameterList.next();
  st = parameterList.next();
  st = parameterList.next();
  st = parameterList.next();
  pl->rp = *st;
  st = parameterList.next();

  st = parameterList.next();
  pl->serial = st->toInt();
  st = parameterList.next();
  pl->refresh = st->toInt();
  st = parameterList.next();
  pl->retry = st->toInt();
  st = parameterList.next();
  pl->TTL = st->toInt();
  st = parameterList.next();
  pl->expire = st->toInt();

  currentRow = 0;
  currentRow = ( const char * ) configData.left( configData.find( "\n" ) + 1 );
  configData = ( const char * ) configData.right( configData.length() - configData.find( "\n" ) - 1 );
  currentRow = currentRow.simplifyWhiteSpace();
  
  for( i = 0; currentRow.find( " " ) != - 1; i++ )
    {
      parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
      currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
    }
  parameterList.append( new QString( ( const char * ) currentRow ) ); 
  
  
  while ( configData.isEmpty() != TRUE || currentRow.isEmpty() != TRUE)
    {
      st = parameterList.first();
      if(st->isEmpty())
	{
	  //debug("NULL");
	}
      else
	{

	  if ( strcmp( ( const char * ) *st, "IN" ) == 0 )
	    {
	      st1 = st;
	      st->remove(0,st->length());
	      //st->append(" ");
	      st2 = parameterList.next();
	      st3 = parameterList.next();
	      st4 = parameterList.next();
	    }
	  else
	    {
	      st1 = parameterList.next();
	      st2 = parameterList.next();
	      st3 = parameterList.next();
	      st4 = parameterList.next();
	    }

	  helprecord=new record();
	  helprecord->owner=0;
	  helprecord->st1=0;
	  helprecord->st2=0;
	  helprecord->i=0;

	  if ( strcmp( ( const char * ) *st2, "A" ) == 0 )
	    {
       	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_A;
	      helprecord->st1=( const char * )*st3;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "NS" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_NS;
	      helprecord->st1=( const char * )*st3;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "MX" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_MX;
	      helprecord->i=st3->toInt();
	      helprecord->st1=( const char * )*st4;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "CNAME" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_CNAME;
	      helprecord->st1=( const char * )*st3;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "PTR" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_PTR;
	      helprecord->st1=( const char * )*st3;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "HINFO" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_HINFO;
	      helprecord->st1=( const char * )*st3;
	      helprecord->st2=( const char * )*st4;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "TXT" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_TXT;
	      helprecord->st1=( const char * )*st3;
	      helprecord->st2=( const char * )*st4;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "WKS" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_WKS;
	      helprecord->st1=( const char * )*st3;
	      helprecord->st2=( const char * )*st4;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "RP" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_RP;
	      helprecord->st1=( const char * )*st3;
	      helprecord->st2=( const char * )*st4;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "AFSDB" ) == 0 )
	    {
	      helprecord->owner=( const char * )*st;
	      helprecord->type=TYPE_AFSDB;
	      helprecord->st1=( const char * )*st3;
	      helprecord->st2=( const char * )*st4;
	      pl->data->append(helprecord);
	    }
	  else if ( strcmp( ( const char * ) *st2, "SOA" ) == 0 )
	    {
	      delete(helprecord);
	    }
	  else
	    {
	      debug("What is this???");
	      debug(*st2);
	      delete(helprecord);
	    }

	}

      st = 0; st1 = 0; st2 = 0; st3 = 0; st4 = 0;
      for ( parameterListItemToRemove = parameterList.first(); //Clear the list.
	    parameterListItemToRemove != 0;
	    parameterListItemToRemove = parameterList.first() )
	{
	  parameterList.remove( parameterListItemToRemove );
	}
      currentRow = ( const char * ) configData.left( configData.find( "\n" ) + 1 );
      configData = ( const char * ) configData.right( configData.length() - configData.find( "\n" ) - 1 );
      currentRow = currentRow.simplifyWhiteSpace();

      for( i = 0; currentRow.find( " " ) != - 1; i++ )
	{
	  parameterList.append( new QString( ( const char * ) currentRow.left( currentRow.find( " " ) ) ) );
	  currentRow = ( const char * ) currentRow.right( currentRow.length() - currentRow.find( " " ) - 1 );
	}
      parameterList.append( new QString( ( const char * ) currentRow ) ); 
    }
}

bool KBindWidget::yes_no(const char *text)
{
  if ( strcmp( text, "yes" ) == 0 )
    return(true);
  else if ( strcmp( text, "true" ) == 0 )
    return(true);
  else if ( strcmp( text, "1" ) == 0 )
     return(true);
  else
     return(false);
}
