/************************************************************
        Copyright (c) 1998 Karl Backstrm

        This code is under GPL - see COPYING.
************************************************************/

#include "bindDialog.h"
#include "bindDialog.moc"
#include <qlabel.h>
#include <qlayout.h>

bindDialog::bindDialog (QListBox *lb, QStrList *lt, const char *caption, 
			const char *text, QWidget* parent, const char* name) 
                        : QDialog ( parent, name, TRUE, 634880 )
{

  QBoxLayout *topLayout = new QVBoxLayout(this, 5);
  QGridLayout *gridLayout = new QGridLayout(1, 5);
  QBoxLayout *buttonLayout = new QHBoxLayout();

  topLayout->addLayout(gridLayout, 10);
  topLayout->addLayout(buttonLayout, 0);

  // gridLayout->setColStretch(0, 10);

  buttonLayout->addStretch(10);

  QFont font( "helvetica", 10, 50, 0 );
  font.setStyleHint( (QFont::StyleHint)0 );
  font.setCharSet( (QFont::CharSet)0 );
  
  Label_1 = new QLabel(text, this);
  Label_1->setMinimumSize(Label_1->sizeHint());
  gridLayout->addWidget(Label_1, 0, 0);

  Text_Edit1 = new QLineEdit(this);
  Text_Edit1->setMinimumSize( 25, 20 );
  Text_Edit1->setFont( font );
  Text_Edit1->setMaxLength(3);
  gridLayout->addWidget(Text_Edit1, 0, 1);

  Text_Edit2 = new QLineEdit(this);
  Text_Edit2->setMinimumSize( 25, 20 );
  Text_Edit2->setFont( font );
  Text_Edit2->setMaxLength(3);
  gridLayout->addWidget(Text_Edit2, 0, 2);

  Text_Edit3 = new QLineEdit(this);
  Text_Edit3->setMinimumSize( 25, 20 );
  Text_Edit3->setFont( font );
  Text_Edit3->setMaxLength(3);
  gridLayout->addWidget(Text_Edit3, 0, 3);

  Text_Edit4 = new QLineEdit(this);
  Text_Edit4->setMinimumSize( 25, 20 );
  Text_Edit4->setFont( font );
  Text_Edit4->setMaxLength(3);
  gridLayout->addWidget(Text_Edit4, 0, 4);

  connect( Text_Edit1, SIGNAL(textChanged(const char*)), SLOT(text1_change(const char*)));
  connect( Text_Edit2, SIGNAL(textChanged(const char*)), SLOT(text2_change(const char*)));
  connect( Text_Edit3, SIGNAL(textChanged(const char*)), SLOT(text3_change(const char*)));
  connect( Text_Edit4, SIGNAL(textChanged(const char*)), SLOT(text4_change(const char*)));
	
  Ok_Button = new QPushButton(i18n("OK"), this);
  Ok_Button->setMinimumSize(Ok_Button->sizeHint());
  connect( Ok_Button, SIGNAL(clicked()), SLOT(OK_Click()) );
  buttonLayout->addWidget(Ok_Button);

  Cancel_Button = new QPushButton(i18n("Cancel"), this);
  Cancel_Button->setMinimumSize(Cancel_Button->sizeHint());
  connect( Cancel_Button, SIGNAL(clicked()), SLOT(Cancel_Click()) );
  buttonLayout->addWidget(Cancel_Button);

  setCaption(caption);
  bindL = lb;
  bindLt = lt;

  setFixedSize(50,50);
  Text_Edit1->setFocus();
  //  gridLayout->addColSpacing(0, 100);
  topLayout->activate();
}


bindDialog::~bindDialog()
{
}

void bindDialog::OK_Click()
{
  QString str;
  str.append(Text_Edit1->text());
  str = str.stripWhiteSpace();
  str.append(".");
  str.append(Text_Edit2->text()); 
  str = str.stripWhiteSpace();
  str.append(".");
  str.append(Text_Edit3->text());
  str = str.stripWhiteSpace();
  str.append(".");
  str.append(Text_Edit4->text());
  str = str.stripWhiteSpace();
  bindLt->append(str);
  bindL->insertItem(str);
  close();
}

void bindDialog::Cancel_Click()
{
  close();
}

void bindDialog::text1_change(const char * name)
{
  if (strlen(name) == 3) Text_Edit2->setFocus();
}
 
void bindDialog::text2_change(const char * name)
{
  if (strlen(name) == 3) Text_Edit3->setFocus();
  else if (strlen(name) == 0) Text_Edit1->setFocus();
}

void bindDialog::text3_change(const char * name)
{
  if (strlen(name) == 3) Text_Edit4->setFocus();
  else if (strlen(name) == 0) Text_Edit2->setFocus();
}

void bindDialog::text4_change(const char * name)
{
  if (strlen(name) == 3) Ok_Button->setFocus();
  else if (strlen(name) == 0) Text_Edit3->setFocus();
}
