/* 
    xWinTV using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef wintvvclip_included
#define wintvvclip_included

#include <wintv.h>

#include <qtooltip.h>
#include <ktopwidget.h>
#include <kstatusbar.h>

#include <cvclip.h> 

#include <vtab.h>
#include <cvclipvideo.h>
#include <cvclipaudio.h>

#include <rcfile.h>
#include <videoclip.h>

/* ------------------------------------------------------------------------------*/
/* ------------------------------------------------------------------------------*/

class winTVVClipWidget : public KTopLevelWidget
{
  Q_OBJECT

public:
  winTVVClipWidget(QWidget* parent = NULL,const char* name = NULL, rcfile *_rc=NULL );
  ~winTVVClipWidget();


public slots:
  void toggleVClipSLOT();
  void frameVClipSLOT(int);
  void framelostVClipSLOT(int);
  void statVideoClipFrameSLOT(double d);

protected slots:
  void optionsSLOT();
  void saveAsSLOT();
  void toggleStatusBarSLOT();
  void vclipSLOT();
  void applyTabSLOT();
  void defaultTabSLOT();
  void cancelTabSLOT();

signals:
  void startVClipSIGNAL(struct MOVIE_PARAMS *);
  void endVClipSIGNAL();

private:
  KStatusBar *statusbar;
  rcfile *rc;

  cvclip *vclip;

  vtab *tab;
  cvclipvideo *cvvideo;
  cvclipaudio *cvaudio;

  bool clip;
  QString dummy;

  QPixmap  pm;

  // parameters for video clips 
  struct MOVIE_PARAMS par;
};

#endif





