/* 
    kwintv using Bt848 frame grabber driver

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <wintv.h>
#include <unistd.h>
#include <qdir.h>
#include <qfile.h>
#include <kapp.h>
#include <kconfig.h>
#include <rcfile.h>
#include <wintvscreen.h>

#ifdef myDEBUG
#define rcDEBUG
#endif

#define GROUP_CONFIG "CONFIG__config"
#define GROUP_GCONFIG "CONFIG__general_config"
#define GROUP_VCCONFIG "CONFIG__video_streamer"
#define GROUP_SSCONFIG "CONFIG__snap_shot"
#define GROUP_FSCONFIG "CONFIG__screen"
#define GROUP_PATHCONFIG "CONFIG__path_to_somewhere"
#define GROUP_MCONFIG "CONFIG__mixer"
#define GROUP_OLCONFIG "CONFIG__behaviour"

rcfile::rcfile() 
{
  og_first_time=1;
  capture=1;
  sound_on=1;
  volume_left=20;
  volume_right=20;
  delay=DEFAULT_DELAY;
  col=DCOL;
  hue=DHUE;
  bri=DBRI;
  contr=DCONTRAST;
  norm=DNORM;
  in=DIN;
  freq=DFREQ;
  country_name=QString("atlantis");
  country_id=0;
  dataDir=QDir::homeDirPath()+QString("/")+QString(RCDIR);
  channelListName=QString(CHFILE);
  bttvDeviceName=QString(V4L_DEVICE);
  ircDeviceName=QString("unused");
  ircDataName=QString("unused");
  automouse=1;
  autosave=1;
  autott=1;
  use_master_volume=0;
  use_tv_volume=0;
  mix_vol_split=mix_bass_split=mix_treble_split=0;
  screensaver=1;
  ss_fixed=0;
  ss_width=160;
  ss_height=120;
  ss_format=SNAPSHOT_PNM;
  ss_prefix=QString("./");
  ss_quality=75;
  mixerDeviceName=QString("/dev/mixer");
  mixerDevice=255;
  aspectRatio=2;
  fixar=0;
  autoar=0;
  vc_audioformat=vc_dimension=vc_audiocapture=0;
  vc_channels=1; // mono
  vc_format=6;
  vc_fps=10;
  vc_bits=8;
  vc_rate=11025;
  vc_tempName=QString("./");
  vc_video_clip=VIDEOCLIP_AVI;
  vc_width=160;
  vc_height=120;
  fs_upper_left=0;
  fs_x=0;
  fs_y=0;
  fs_switch_res=0;
  fs_infooverlay=1;
  fs_res=0;
  version=INTVERSION;
  ol_restore=0;
  ol_toolbar=1;
  ol_menubar=1;
  ol_statusbar=1;
  ol_geometry=QRect();
  ol_channel=0;
  ol_tooltips=1;
  posOfChannelBox=3;
  autoplaceChannelBox=0;
  border=0;
  ol_ch_wasvis=ol_mix_wasvis=0;
}


rcfile::~rcfile()
{
#ifdef rcDEBUG
  debug("rc: ~rcfile()");
#endif
  save();
}


int rcfile::load()
{
  bool newflag= false;

  QDir rcdir(dataDir);
  if (!rcdir.exists()) {
    rcdir.mkdir(rcdir.absPath());
    //chown((const char*)rcdir.absPath(),getuid(),getgid());
    newflag= true;
  }

  KConfig *config=kapp->getConfig();

  config->setGroup(GROUP_CONFIG);

  version=config->readNumEntry("version",0);
  og_first_time=config->readNumEntry("og_first_time",og_first_time);

  config->setGroup(GROUP_GCONFIG);
  
  capture=config->readNumEntry("capture",capture);
  col=config->readNumEntry("color",col);
  hue=config->readNumEntry("hue",hue);
  contr=config->readNumEntry("contrast",contr);
  bri=config->readNumEntry("brightness",bri);
  norm=config->readNumEntry("norm",norm);
  in=config->readNumEntry("input",in);
  freq=config->readNumEntry("frequency",freq);
  country_id=config->readNumEntry("country_id",country_id);

  config->setGroup(GROUP_PATHCONFIG);

  country_name=config->readEntry("country_name",country_name);
  dataDir=config->readEntry("dataDir",dataDir);
  channelListName=config->readEntry("channelListName",channelListName);
  bttvDeviceName=config->readEntry("bttvDeviceName",bttvDeviceName);
  ircDeviceName=config->readEntry("ircDeviceName",ircDeviceName);
  ircDataName=config->readEntry("ircDataName",ircDataName);
 
  config->setGroup(GROUP_MCONFIG);

  use_tv_volume=config->readNumEntry("use_tv_volume",use_tv_volume);
  use_master_volume=config->readNumEntry("use_master_volume",use_master_volume);
  sound_on=config->readNumEntry("unmuted",sound_on);
  volume_left=config->readNumEntry("vol_left",volume_left);
  volume_right=config->readNumEntry("vol_right",volume_right);
  mixerDeviceName=config->readEntry("mixerDeviceName",mixerDeviceName);
  mixerDevice=config->readNumEntry("mixerDevice",mixerDevice);
  mix_vol_split=config->readNumEntry("mix_vol_split",mix_vol_split);
  mix_bass_split=config->readNumEntry("mix_bass_split",mix_bass_split);
  mix_treble_split=config->readNumEntry("mix_treble_split",mix_treble_split);

  config->setGroup(GROUP_SSCONFIG);

  ss_fixed=config->readNumEntry("ss_fixed",ss_fixed);
  ss_width=config->readNumEntry("ss_width",ss_width);
  ss_height=config->readNumEntry("ss_height",ss_height);
  ss_format=config->readNumEntry("ss_format",ss_format);
  ss_quality=config->readNumEntry("ss_quality",ss_quality);
  ss_prefix=config->readEntry("ss_prefix",ss_prefix);
  
  config->setGroup(GROUP_VCCONFIG);

  vc_audioformat=config->readNumEntry("vc_audioformat",vc_audioformat);
  vc_dimension=config->readNumEntry("vc_dimension",vc_dimension);
  vc_format=config->readNumEntry("vc_format",vc_format);
  vc_audiocapture=config->readNumEntry("vc_audiocapture",vc_audiocapture);
  vc_fps=config->readNumEntry("vc_fps",vc_fps);
  vc_channels=config->readNumEntry("vc_channels",vc_channels);
  vc_bits=config->readNumEntry("vc_bits",vc_bits);
  vc_rate=config->readNumEntry("vc_rate",vc_rate);
  vc_tempName=config->readEntry("vc_tempName",vc_tempName);
  vc_video_clip=config->readNumEntry("vc_video_clip",vc_video_clip);
  vc_height=config->readNumEntry("vc_height",vc_height);
  vc_width=config->readNumEntry("vc_width",vc_width);

  config->setGroup(GROUP_FSCONFIG);

  fs_upper_left=config->readNumEntry("fs_upper_left",fs_upper_left);
  fs_x=config->readNumEntry("fs_x",fs_x);
  fs_y=config->readNumEntry("fs_y",fs_y);
  fs_switch_res=config->readNumEntry("fs_switch_res",fs_switch_res);
  fs_infooverlay=config->readNumEntry("fs_infooverlay",fs_infooverlay);
  fs_res=config->readNumEntry("fs_res",fs_res);
  aspectRatio=config->readNumEntry("aspect_ratio",aspectRatio);
  autoar=config->readNumEntry("autoar",autoar);
  fixar=config->readNumEntry("fixar",fixar);

  config->setGroup(GROUP_OLCONFIG);

  ol_restore=config->readNumEntry("ol_restore",ol_restore);
  ol_toolbar=config->readNumEntry("ol_toolbar",ol_toolbar);
  ol_menubar=config->readNumEntry("ol_menubar",ol_menubar);
  ol_statusbar=config->readNumEntry("ol_statusbar",ol_statusbar);
  ol_geometry=config->readRectEntry("ol_geometry",&ol_geometry);
  ol_channel=config->readNumEntry("ol_channel",ol_channel);
  ol_tooltips=config->readNumEntry("ol_tooltips",ol_tooltips);
  automouse=config->readNumEntry("automouse",automouse);
  autosave=config->readNumEntry("autosave",autosave);
  autott=config->readNumEntry("autott",autott);
  screensaver=config->readNumEntry("screensaver",screensaver);
  posOfChannelBox=config->readNumEntry("posOfChannelBox",posOfChannelBox);
  autoplaceChannelBox=config->readNumEntry("autoplaceChannelBox",autoplaceChannelBox);
  ol_mix_wasvis=config->readNumEntry("ol_mix_wasvis",ol_mix_wasvis);
  ol_ch_wasvis=config->readNumEntry("ol_ch_wasvis",ol_ch_wasvis);
  ol_allowdocking=config->readNumEntry("ol_allowdocking",ol_allowdocking);

  return(version); 
}

int rcfile::save()
{
  KConfig *config=kapp->getConfig();

  config->setGroup(GROUP_CONFIG);

  config->writeEntry("version",INTVERSION);
  config->writeEntry("og_first_time",og_first_time);

  config->setGroup(GROUP_GCONFIG);

  config->writeEntry("capture",capture);
  config->writeEntry("color",col);
  config->writeEntry("hue",hue);
  config->writeEntry("contrast",contr);
  config->writeEntry("brightness",bri);
  config->writeEntry("norm",norm);
  config->writeEntry("input",in);
  config->writeEntry("frequency",freq);
  config->writeEntry("country_id",country_id);

  config->setGroup(GROUP_PATHCONFIG);

  config->writeEntry("country_name",country_name);
  config->writeEntry("dataDir",dataDir);
  config->writeEntry("channelListName",channelListName);
  config->writeEntry("bttvDeviceName",bttvDeviceName);
  config->writeEntry("ircDeviceName",ircDeviceName);
  config->writeEntry("ircDataName",ircDataName);

  config->setGroup(GROUP_SSCONFIG);

  config->writeEntry("ss_fixed",ss_fixed);
  config->writeEntry("ss_width",ss_width);
  config->writeEntry("ss_height",ss_height);
  config->writeEntry("ss_format",ss_format);
  config->writeEntry("ss_quality",ss_quality);
  config->writeEntry("ss_prefix",ss_prefix);

  config->setGroup(GROUP_MCONFIG);

  config->writeEntry("mixerDeviceName",mixerDeviceName);
  config->writeEntry("mixerDevice",mixerDevice);
  config->writeEntry("use_tv_volume",use_tv_volume);
  config->writeEntry("use_master_volume",use_master_volume);
  config->writeEntry("unmuted",sound_on);
  config->writeEntry("vol_left",volume_left);
  config->writeEntry("vol_right",volume_right);
  config->writeEntry("mix_vol_split",mix_vol_split);
  config->writeEntry("mix_bass_split",mix_bass_split);
  config->writeEntry("mix_treble_split",mix_treble_split);

  config->setGroup(GROUP_VCCONFIG);

  config->writeEntry("vc_audioformat",vc_audioformat);
  config->writeEntry("vc_dimension",vc_dimension);
  config->writeEntry("vc_format",vc_format);
  config->writeEntry("vc_audiocapture",vc_audiocapture);
  config->writeEntry("vc_fps",vc_fps);
  config->writeEntry("vc_channels",vc_channels);
  config->writeEntry("vc_bits",vc_bits);
  config->writeEntry("vc_rate",vc_rate);
  config->writeEntry("vc_tempName",vc_tempName);
  config->writeEntry("vc_video_clip",vc_video_clip);
  config->writeEntry("vc_height",vc_height);
  config->writeEntry("vc_width",vc_width);

  config->setGroup(GROUP_FSCONFIG);
  config->writeEntry("fs_upper_left",fs_upper_left);
  config->writeEntry("fs_x",fs_x);
  config->writeEntry("fs_y",fs_y);
  config->writeEntry("fs_switch_res",fs_switch_res);
  config->writeEntry("fs_res",fs_res);
  config->writeEntry("fs_infooverlay",fs_infooverlay);
  config->writeEntry("aspect_ratio",aspectRatio);
  config->writeEntry("autoar",autoar);
  config->writeEntry("fixar",fixar);

  config->setGroup(GROUP_OLCONFIG);
  config->writeEntry("ol_restore",ol_restore);
  config->writeEntry("ol_toolbar",ol_toolbar);
  config->writeEntry("ol_menubar",ol_menubar);
  config->writeEntry("ol_statusbar",ol_statusbar);
  config->writeEntry("ol_geometry",ol_geometry);
  config->writeEntry("ol_channel",ol_channel);
  config->writeEntry("ol_tooltips",ol_tooltips);
  config->writeEntry("automouse",automouse);
  config->writeEntry("autosave",autosave);
  config->writeEntry("autott",autott);
  config->writeEntry("screensaver",screensaver);
  config->writeEntry("posOfChannelBox",posOfChannelBox);
  config->writeEntry("autoplaceChannelBox",autoplaceChannelBox);
  config->writeEntry("ol_mix_wasvis",ol_mix_wasvis);
  config->writeEntry("ol_ch_wasvis",ol_ch_wasvis);
  config->writeEntry("ol_allowdocking",ol_allowdocking);

  config->sync();

#ifdef rcDEBUG
  debug("rc: rc saved");
#endif

  return(0);
}

const char * rcfile::getRCFileName() 
{ 
  return (const char *)(QDir::homeDirPath()+"/.kde/share/config/kwintvrc"); 
}

bool rcfile::checkVersion( bool deleteold )
{
  if ( version < NEWFORMATVERSION ) {
    if ( deleteold ) {
      return QFile::remove((const char *)(QDir::homeDirPath()+"/.kde/share/config/kwintvrc"));
    }
    return true;
  }
  return false;
}


