#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>

#include "rawvideoclip.h"
#include "colorspace.h"

#include <asm/types.h>

#ifdef HAVE_CONFIG_H
#include <config.h>  // config.h by configure
#endif

#ifdef USE_KERNEL_VIDEODEV
#include <linux/videodev.h>
#else
#include <videodev.h>
#endif

static char graberror[256];
#define GRAB_PERROR(action,file) \
  {sprintf(graberror,"%s: %s: %s",action,file,strerror(errno));fprintf(stderr,graberror);return -1;}

#define TRAP(txt) fprintf(stderr,"%s:%d:%s\n",__FILE__,__LINE__,txt);exit(1);


/* ----------------------------------------------------------------------- */

rawVideoClip::rawVideoClip():videoClip()
{
  strcpy(name,"RAW video file");
  video_formats=VIDEO_PALETTE_RGB24 | VIDEO_PALETTE_RAW
    | VIDEO_PALETTE_GREY | VIDEO_PALETTE_YUV411 | VIDEO_PALETTE_YUV422;
  audio_formats=AUDIO_NONE;
  
}

int rawVideoClip::open(char *filename, struct MOVIE_PARAMS *par)
{
  frames=0;

  strcpy(ext,raw_formats[par->video_format].ext);
  strcpy(file,filename);
  if (strstr(file,ext) == NULL) strcat(file,ext);
  strcpy(par->extension,ext);
  
  memcpy(&params,par,sizeof(struct MOVIE_PARAMS));

  params.video_format=raw_formats[par->video_format].bt848;

  frame_bytes  = params.width * params.height * 
    raw_formats[par->video_format].mul / raw_formats[par->video_format].div;
  framebuf = (unsigned char *)malloc(frame_bytes);

  if (-1 == (fd = ::open(file,O_CREAT | O_RDWR | O_TRUNC, 0666))) GRAB_PERROR("open",file);

  return 0;
}

int rawVideoClip::writeframe(char * data)
{
  switch (raw_formats[params.video_format].post) {
  case POST_RGB_SWAP: 
    rgb24_to_bgr24(framebuf,(unsigned char *)data,params.width,params.height);
    rc= write(fd,framebuf,frame_bytes);
    break;
  case POST_UNPACK422:
    packed422_to_planar422(framebuf,(unsigned char *)data,params.width,params.height);
    rc= write(fd,framebuf,frame_bytes);
    break;
  case POST_UNPACK411:
    packed422_to_planar411(framebuf,(unsigned char *)data,params.width,params.height);
    rc= write(fd,framebuf,frame_bytes);
    break;
  default:
    rc= write(fd,framebuf,frame_bytes);
  }
  if ( -1 == rc ) GRAB_PERROR("write",file);

  frames++;
  return 0;
}

int rawVideoClip::close()
{
  ::close(fd);
  return 0;
}



