#ifndef avivideoclip_h
#define avivideoclip_h

#include <videoclip.h>
#include <dsp.h>

/*------------------------------------------------------------------------------*/

class aviVideoClip : public videoClip
{
public:
  aviVideoClip();
  virtual ~aviVideoClip();

  int open(char *filename, struct MOVIE_PARAMS *par);
  int writeframe(char * data);
  int close();

  int nframes() { return frames; }

private:
  // statistics 
  int hdr_size;
  
  int audio_size;
  int total_size;

  /// video stuff 
  int frame_bytes, screen_bytes;
  unsigned char *framebuf;

  unsigned char *d;
  int y,rc;

  // dsp
  dsp * thedsp;
  int audiodatasize;
};

#endif avivideoclip_h





