/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef Kv4lAPP_H
#define Kv4lAPP_H

#include "kapp.h"
#include "qv4lwin.h"
#define qv4lApp Kv4lApplication::getKv4lApplication()

class Kv4lApplication : public KApplication
{
	Q_OBJECT
public:
	Kv4lApplication( int& argc, char** argv );
	Kv4lApplication( int& argc, char** argv, const QString& rAppName );

	virtual ~Kv4lApplication();

	void installWidget ( Qv4lWin *);
	void deInstallWidget ( Qv4lWin *);
	static Kv4lApplication* getKv4lApplication() { return qV4LApp; }

protected:
	virtual bool x11EventFilter( XEvent * );
	static Kv4lApplication *qV4LApp;

private:
	// Does someone need more than 20 widgets in the same application
	Qv4lWin *wlist[20];
	
};


#endif

