/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include "kv4lapp.h"

Kv4lApplication *Kv4lApplication::qV4LApp=0L;

static void Kv4lDummyMessageHandler( QtMsgType type, const char *msg )
{
	switch ( type ) 
	{
		case QtDebugMsg:
			fprintf( stderr, "Debug: %s\n", msg );
			break;
		case QtWarningMsg:
			fprintf( stderr, "Warning: %s\n", msg );
			break;
		case QtFatalMsg:
			fprintf( stderr, "Fatal: %s\n", msg );
			break;
		}
}

Kv4lApplication::Kv4lApplication(int &argc, char **argv) :
	KApplication( argc, argv )
{
	qInstallMsgHandler( Kv4lDummyMessageHandler );
    for ( int i=0; i<19; i++)
		wlist[i] = 0L;
	qV4LApp = this;

}


Kv4lApplication::Kv4lApplication( int& argc, char** argv, 
	const QString& rAppName ): KApplication( argc, argv, rAppName )
{
	qInstallMsgHandler( Kv4lDummyMessageHandler );
    for ( int i=0; i<19; i++) 
    	wlist[i] = 0L;
    qV4LApp = this;

}


Kv4lApplication::~Kv4lApplication()
{}

bool
Kv4lApplication::x11EventFilter( XEvent *e)
{
    for (int i=0; i<19; i++)
	if (wlist[i]){	
	    QWidget * parent = wlist[i];
	    while (parent){
		if (parent->winId() == e->xany.window){
		    wlist[i]->x11ExtraEventFilter(e);
		    break;}
		    parent = parent->parentWidget();}}

    return (KApplication::x11EventFilter( e));
}

void
Kv4lApplication::installWidget( Qv4lWin * w)
{
    for (int i=0;i<19; i++)
	if (wlist[i] == 0L){
	    wlist[i] = w;
	    break;}
}

void
Kv4lApplication::deInstallWidget( Qv4lWin * w)
{
    for (int i=0; i<19; i++)
	if (wlist[i] == w){
	    wlist[i] = 0L;
    	    break;}
}

#include "kv4lapp.moc"
