#include <qtooltip.h>
#include "globals.h"
#include "songbar.h"

SongBar::SongBar( int chan, QWidget *parent )
:QFrame( parent, 0, 0, TRUE )
{
    int curwidth;
    channel = chan;

    curwidth = 0;

    type = new BTrackEditButton( channel, this );
    type->move( curwidth, 0 );
    type->resize( 30, 25 );

    curwidth += type->width();

    mchan = new BPopSelect( 0, 0, 15, this );
    mchan->move( curwidth, 0 );
    mchan->resize( 22, 25 );
    QObject::connect( mchan, SIGNAL( valueChanged( int ) ), this, SLOT( _mchannelChanged( int ) ) );
    QToolTip::add( mchan, "MIDI Channel" );

    curwidth += mchan->width();

    name = new QLineEdit( this );
    name->setText( "name" );
    name->move( curwidth, 0 );
    name->resize( 75, 25 );

    curwidth += name->width();

    devnum = new BPopSelect( 0, 0, gsong->getMaxMidiDevice() - 1, this );
    devnum->move( curwidth, 0 );
    devnum->resize( 15, 25 );
    QObject::connect( devnum, SIGNAL( valueChanged( int ) ), this, SLOT( _deviceChanged( int ) ) );
    QToolTip::add( devnum, "Device Number" );

    curwidth += devnum->width();

    mute = new BCheckLetter( 'M', "yellow", this );
    mute->move( curwidth, 0 );
    QObject::connect( mute, SIGNAL( valueChanged( bool ) ), this, SLOT( _muteChanged( bool ) ) );
    QToolTip::add( mute, "Mute Channel" );

    curwidth += mute->width();

    solo = new BCheckLetter( 'S', "green", this );
    solo->move( curwidth, 0 );
    QObject::connect( solo, SIGNAL( valueChanged( bool ) ), this, SLOT( _soloChanged( bool ) ) );
    QToolTip::add( solo, "Solo Channel" );

    curwidth += solo->width();

    sep = new QFrame( this );
    sep->setFrameStyle( QFrame::VLine | QFrame::Raised );
    sep->setLineWidth( 2 );
    sep->resize( 10, 30 );
    sep->move( curwidth, -5 );

    curwidth += sep->width();
    leftbarwidth = curwidth;

    patterns = new BPatternBar( channel, this );
    patterns->move( curwidth, 0 );
    patterns->setFocus();
    QObject::connect( patterns, SIGNAL( cursorUp( int ) ), this, SLOT( _barCursorUp( int ) ) );
    QObject::connect( patterns, SIGNAL( cursorDown( int ) ), this, SLOT( _barCursorDown( int ) ) );
    QObject::connect( patterns, SIGNAL( giveCursor( int ) ), this, SLOT( _barGiveCursor( int ) ) );
    QObject::connect( patterns, SIGNAL( patternClicked( int ) ), this, SLOT( _patternClicked( int ) ) );

    reSync();

    resize( leftbarwidth + patterns->width(), 25 );
}

int SongBar::leftBarWidth()
{
    return leftbarwidth;
}

void SongBar::_patternClicked( int pos )
{
    if ( tracker == NULL ) {
        tracker = new TTracker( channel, gsong->getSongPatternIndex( channel, pos ), 0 );
        tracker->show();
    } else {
        tracker->patternChange( gsong->getSongPatternIndex( channel, pos ) );
        tracker->show();
    }
}

void SongBar::scrollPatternBar( int newpos )
{
    patterns->setLeftPos( newpos );
}

void SongBar::_mchannelChanged( int mchan )
{
    gsong->setMidiChannel( channel, mchan );
}

void SongBar::_deviceChanged( int newdev )
{
    gsong->setChannelDevice( channel, newdev );
}

void SongBar::_muteChanged( bool newmute )
{
    gsong->setChannelMute( channel, newmute );
}

void SongBar::_soloChanged( bool newsolo )
{
    gsong->setChannelSolo( channel, newsolo );
}

void SongBar::_barCursorUp( int pos )
{
    barCursorUp( channel, pos );
}

void SongBar::_barCursorDown( int pos )
{
    barCursorDown( channel, pos );
}

void SongBar::_barGiveCursor( int pos )
{
    barGiveCursor( channel, pos );
}

void SongBar::getBarCursor( int pos )
{
    patterns->getCursor( pos );
}

void SongBar::noBarCursor()
{
    patterns->noCursor();
}

void SongBar::zoomInPattern()
{
    patterns->zoomIn();
}

void SongBar::zoomOutPattern()
{
    patterns->zoomOut();
}

void SongBar::reSync()
{
    mchan->setValue( gsong->getMidiChannel( channel ) );
    devnum->setValue( gsong->getChannelDevice( channel ) );
    mute->setState( gsong->isChannelMuted( channel ) );
    solo->setState( gsong->isChannelSolo( channel ) );
}

void SongBar::setName( const char *newname )
{
    name->setText( newname );
}

const char *SongBar::getName()
{
    return name->text();
}

