#ifndef SAMPLECHANNEL_H_INCLUDED
#define SAMPLECHANNEL_H_INCLUDED

#include <qstring.h>

#include <defines.h>

class sampleChannel {
private:
	// Buffer data
	int size;
	sample_t *data;

	// Current pointer
	int pos;
	sample_t *curbuff;

	float pan; // -1 to +1
	float right_amp;
	float left_amp;
	float volume; // 0 onwards
	float master_volume;
	inline float getMasterVolume() const { return master_volume; };
	QString original_filename;
public:
	sampleChannel();

	void loadSample( const char *filename );

	inline float getPan() const { return pan; };
	inline float getVolume() const { return volume; };
	inline float getRightAmplification() const { return right_amp; };
	inline float getLeftAmplification() const { return left_amp; };
	inline const char *filename() const { return original_filename; };

	inline void off() { pos = size; };
	inline void on() { pos = 0; curbuff = data; };
	inline BOOL isOn() const { return ( pos < size ); };

	inline sample_t getFrame() { pos++; return *curbuff++; };

	void setPan( int newpan );
	void setVolume( int newvol );
	void calculateAmplification();
};

#endif
