#ifndef DEVICESELECTOR_H_INCLUDED
#define DEVICESELECTOR_H_INCLUDED

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qpushbutton.h>

#include <btoolbutton.h>

class DeviceSelector : public QWidget
{
	Q_OBJECT
public:
	DeviceSelector( QWidget *parent );

private:
	QListView *devicelist;
	QPushButton *openDevice;
	QPushButton *closeDevice;
	QPushButton *addDevice;
	void rescanList();
	void resizeEvent( QResizeEvent * );
private slots:
	void openPressed();
	void closePressed();
	void addPressed();
signals:
	void newDevice( int );
};

class LittleDeviceButton : public QWidget
{
	Q_OBJECT
public:
	LittleDeviceButton( QWidget *parent );
private:
	QLabel *devicelabel;
	BToolButton *changedevbutton;
	DeviceSelector *devselect;
private slots:
	void changePressed();
	void newDevice( int newdev );
};

#endif // DEVICESELECTOR_H_INCLUDED
