// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MGetNumberParameter.cc,v $
// $Revision: 1.2 $
// $Date: 1999/05/16 19:11:40 $
// $State: Exp $
// **************************************************************

#define MODULE_NAME "get-number-parameter"

#include "ModuleMacros.h"

BEGIN_MODULE_DEFINITION(GetNumberParameter);
    Slot *nslot_input;
public:
    string toString() const;
END_MODULE_DEFINITION(GetNumberParameter);

class NSGetNumberParameterOutput : public Signal
{
public:
    NSGetNumberParameterOutput(Module *m) 
	: Signal(NUMBER_TYPE, "output", "Exactly what comes from input", m) {};
    PreparedSignal *prepareSignal(Metainfo *, const Parameterset *);
};

// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------

MGetNumberParameter::MGetNumberParameter(string slotname)
{
    if (slotname == "")  // newly created
    {
	addConnector(nslot_input 
		    = new Slot(NUMBER_TYPE, "par", "Preferably used as parameter slot", this, 8));
	nslot_input->makeParameter();
    }
    else addConnector(nslot_input 
		     = new Slot(NUMBER_TYPE, slotname, "Preferably used as parameter slot", this, 8));

    addConnector(new NSGetNumberParameterOutput(this));
}


PreparedSignal *NSGetNumberParameterOutput::prepareSignal(Metainfo *, const Parameterset *)
{
    return ((MGetNumberParameter *)getModule())->nslot_input->getPreparedSignal(this);
}

string MGetNumberParameter::toString() const
{
    return nslot_input->getName();
}
