#include <stdio.h>

#include "MNumber.h"
#include "EnterValueDialog.h"
#include "LookMacros.h"

class MLNumber : public ModuleLook
{
public:
    MLNumber(Module *module, ModuleLookGenerator *gen) : ModuleLook(module, gen) {};
    bool isControl() { return true; }; // see ModuleLook
    bool mousePressed(const QPoint&);
};

class MLGNumber : public ModuleLookGenerator
{
public:
    ModuleLook *create(Module *module) { return new MLNumber(module, this); };
    string getName()       const { return "number"; };
    const char *menuPath() const { return "Constants"; };
    QSize gridSize()       const { return QSize(4,1); };
    void paint(QPainter&, Module *);
};

MLGNumber mlg_Number;

bool MLNumber::mousePressed(const QPoint&)
{
    MNumber *mnumber = (MNumber *)getModule();
    mnumber->setValue(EnterValueDialog::getNumber("Enter a number", mnumber->getValue()));
    return true; // graphical update neccessary.
}


void MLGNumber::paint(QPainter& p, Module *module)
{
    string text;
    
    if (module) {
	Number value = ((MNumber *)module)->getValue();
	char string[64];
	sprintf(string, "%5.2f",value);
	text = string;
    }
    else text = "0.00";
    
    QRect textbox(QPoint(0,0), size()); // pos is in pixles
    p.setBackgroundColor(QColor(0x46, 0x82, 0xb4));
    p.eraseRect(textbox);
    p.setPen(white);
    p.drawText(textbox, AlignRight | AlignVCenter, text.c_str());
}
