// -*- c++ -*-
#ifndef SamplingConfigDialog_h
#define SamplingConfigDialog_h

#include <qdialog.h>

#include "BasicTypes.h"

#define NUM_SAMPLING_RATES 9

class QCheckBox;
class QPushbutton;
class QSlider;
class QLabel;
class QButtonGroup;
class QRadioButton;

#include "SamplingConfig.h"

struct SamplingConfigExt : public SamplingConfig
{
    bool show_seconds;
    unsigned int frags_per_display_refresh;
    SamplingConfigExt() { show_seconds=true; frags_per_display_refresh=2; };
};


class SamplingConfigDialog : public QDialog
{
    SamplingConfigExt *config;

    Q_OBJECT
    
    QButtonGroup *w_samplingrates, *w_samplesizes;
    QRadioButton *w_samplingrate[NUM_SAMPLING_RATES], *w_samplesize[2];
    QCheckBox *w_show_seconds;

    QPushButton *w_okbutton, *w_cancelbutton, *w_helpbutton;
    QSlider *w_writeahead;
    QLabel  *l_writeahead;
    QSlider *w_fragmentsize;
    QLabel  *l_fragmentsize;
    QSlider *w_frags_per_display_refresh;
    QLabel  *l_frags_per_display_refresh;

public:
    SamplingConfigDialog(SamplingConfigExt *config);

private slots:
    void help();
    void dataFromWidgets();
    void fragmentsizeChanged(int);
    void writeaheadChanged(int);
    void fpdrChanged(int);
private:
    void dataToWidgets();
};

#endif // SamplingConfigDialog_h
