// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/ModuleLook.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#ifndef ModuleLook_h
#define ModuleLook_h

#include <string>

#include <qpainter.h>
#include <qpixmap.h>

#include "LayoutElement.h"
#include "gridspacing.h"
#include "SignalTypes.h"
#include "Module.h"

class ModuleLookGenerator;
class QPopupMenu;

/**
 * @short User interface of a Module.
 * This is an abstract base class. The MacroModuleLook creates a ModuleLook object
 * for each Module that the MacroModule that it is editing contains.
 * A ModuleLook can be painted, is able to handle mouse events, can create a wire menu
 * and gives access to the underlying Module.
 */
class ModuleLook : public LayoutElement
{
    /**
     * The underlying @ref Module. It is not owned and may not be deleted
     * by this object.
     */
    Module *module;

    /**
     * The Generator that generated this ModuleLook. The generator is also responsible
     * for drawing the ModuleLook.
     */
    ModuleLookGenerator *generator;

public:

    ModuleLook(Module *module, ModuleLookGenerator *generator);

    /**
     * Returns a pointer to the underlying Module.
     */
    Module *getModule() const;

    QPopupMenu *createWireMenu(Connector *) const;

    QSize  gridSize()   const;
    short  gridLeft()       const;
    short  left()           const;
    short  gridTop()        const;
    short  top()            const;
    QPoint gridPos()        const;
    QPoint pos()            const;
    QRect  gridRect()       const;
    QRect  rect()           const;
    QPoint center()         const;
    QRect  rectWithBorder() const;
    QRect  sizeWithBorder() const;
    QRect  rectOfAura()     const;
    void   gridMove(const QPoint& vector);
    void   gridMoveTo(const QPoint& gridpos);
    bool   intersects(const QRect&) const; // including border!
    void   paintAura(QPainter& p) const;

    // paint operations (some of them inherited from LayoutElement)

    /**
     * Indicates that this module's data has changed. Probably it
     * should be repainted. It is used by display modules, if their
     * data to be display has changed.
     * 
     * Whenever this method is called, the module should should assume,
     * that it now will be repainted immediately. It can clear its
     * internal "needs_repaint" flag. Therefor this method is NOT
     * const.
     */
    virtual bool needsRepaint();

    void   paint(QPainter& p);
    void   paintBorder(QPainter& p) const;
    void   paintSelection(QPainter& p) const;

    // override this to define ModuleLook's properties 

    virtual bool   isControl()                 { return false; };
    virtual bool   mousePressed(const QPoint&) { return false; };
    virtual bool   mouseMoved(const QPoint&)   { return false; };
    virtual bool   mouseReleased()             { return false; };

private:
    QPixmap createWireMenuPixmap(bool signal_and_not_slot, SignalType type, 
				 bool is_connected, bool is_parameter,
				 bool select_for_parameter,
				 string name, string description, short wirecolor) const;
};


#endif // ModuleLook_h
