// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/LookInfoDialog.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#include <qlayout.h>
#include <qlabel.h>
#include <kmsgbox.h>
#include <stdio.h>

#include "LookInfoDialog.h"
#include "LookInfoDialog-moc.h"
#include "LookInfoTypes.h"
#include "MacroModuleLook.h"

LookInfoDialog::LookInfoDialog(MacroModuleLook *mml, const LookInfo &old_look)
    : QDialog(0, "look", TRUE) // true = modal
    , mml(mml)
    , old_look(old_look)
    , filedialog(0, 0, 0, "file_dialog", TRUE)
{
    setCaption("Module's Look");
    filedialog.setCaption("Select a background image");
    
    // Create Leaves of layout tree: widgets manipulated by the user.
    // Data Widgets

    w_name            = new QLineEdit(this);
    w_name            ->setMinimumSize(w_name->sizeHint());
    w_description     = new QLineEdit(this);
    w_description     ->setMinimumSize(w_description->sizeHint());
    w_image_button    = new QPushButton("&Load Image", this);
    w_image_button    ->setMinimumSize(w_image_button->sizeHint());
    w_backgroundcolor = new KColorButton(toQ(old_look.backgroundcolor), this);
    w_backgroundcolor ->setMinimumSize(w_image_button->sizeHint());
    w_textcolor       = new KColorButton(toQ(old_look.textcolor), this);
    w_textcolor       ->setMinimumSize(w_image_button->sizeHint());
    w_text_layout     = new QCheckBox("", this); 
    w_text_layout     ->setMinimumSize(QSize(15, 15));
    w_layouttext      = new QLineEdit(this);
    w_layouttext      ->setMinimumSize(w_layouttext->sizeHint());
    w_image_layout    = new QCheckBox("", this);
    w_image_layout    ->setMinimumSize(QSize(15, 15));
    w_separators      = new QCheckBox("", this);
    w_separators      ->setMinimumSize(QSize(15, 15));
    w_threed_borders  = new QCheckBox("", this);
    w_threed_borders  ->setMinimumSize(QSize(15, 15));
    w_rounded_edges  = new QCheckBox("", this);
    w_rounded_edges  ->setMinimumSize(QSize(15, 15));

    l_text        = new QLabel(w_layouttext,   "&Text:", this);
    l_text->setMinimumSize( l_text->sizeHint() + QSize(3,3));
    l_textcolor   = new QLabel(w_textcolor,    "Text &Color:", this);
    l_textcolor->setMinimumSize( l_textcolor->sizeHint() + QSize(3,3));
    l_image       = new QLabel(w_image_layout, "&Image:", this);
    l_image->setMinimumSize( l_image->sizeHint() + QSize(3,3));

    l_preview = new QLabel(this);

    readOldSettings();
    somethingChanged();

    connect(w_backgroundcolor, SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_text_layout,     SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_threed_borders,  SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_rounded_edges,   SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_separators,      SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_image_button,    SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_image_layout,    SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_textcolor,       SIGNAL(clicked()), this, SLOT(somethingChanged()));
    connect(w_layouttext,      SIGNAL(textChanged(const char *)), this, 
	    SLOT(somethingChanged(const char *)));
    connect(w_image_button,    SIGNAL(clicked()), this, SLOT(loadImage()));

    // Control Widgets

    w_okbutton        = new QPushButton("OK", this);
    w_okbutton        -> setMinimumSize(w_okbutton->sizeHint());
    w_okbutton        ->setDefault(true);
    w_cancelbutton    = new QPushButton("Cancel", this);
    w_cancelbutton    -> setMinimumSize(w_cancelbutton->sizeHint());

    connect(w_okbutton,        SIGNAL(clicked()), this, SLOT(accept()));
    connect(w_cancelbutton,    SIGNAL(clicked()), this, SLOT(reject()));

    // Contruct layout tree
    QVBoxLayout *toplayout = new QVBoxLayout(this, 4, 4);
    
    // Data widgets

    QGridLayout *gridlayout = new QGridLayout(10, 3, 6);
    toplayout->addLayout(gridlayout);

    QLabel *label;

    label = new QLabel(w_name, "&Unique name:", this);
    label->setMinimumSize( label->sizeHint() + QSize(3,3));
    gridlayout->addWidget(label,             0, 1);
    gridlayout->addWidget(w_name,            0, 2);

    label = new QLabel(w_description, "&Description:", this);
    label->setMinimumSize( label->sizeHint() + QSize(3,3));
    gridlayout->addWidget(label,             1, 1);
    gridlayout->addWidget(w_description,     1, 2);

    label = new QLabel(w_backgroundcolor, "&Background Color:", this);
    label->setMinimumSize( label->sizeHint() + QSize(3,3));
    gridlayout->addWidget(label,             2, 1);
    gridlayout->addWidget(w_backgroundcolor, 2, 2);
    gridlayout->addWidget(l_textcolor,       3, 1);
    gridlayout->addWidget(w_textcolor,       3, 2);
    gridlayout->addWidget(w_text_layout,     4, 0);
    gridlayout->addWidget(l_text,            4, 1);
    gridlayout->addWidget(w_layouttext,      4, 2);
    gridlayout->addWidget(w_image_layout,    5, 0);
    gridlayout->addWidget(l_image,           5, 1);
    gridlayout->addWidget(w_image_button,    5, 2);

    label = new QLabel(w_separators, "&Separators between Modules", this);
    label->setMinimumSize( label->sizeHint() + QSize(3,3));
    gridlayout->addWidget(w_separators, 6, 0);
    gridlayout->addMultiCellWidget(label, 6, 6, 1, 2);

    label = new QLabel(w_threed_borders, "&3D Borders", this);
    label->setMinimumSize(label->sizeHint() + QSize(3,3));
    gridlayout->addWidget(w_threed_borders, 7, 0);
    gridlayout->addMultiCellWidget(label, 7, 7, 1, 2);
    label = new QLabel(w_rounded_edges, "&Rounded Edges", this);
    label->setMinimumSize(label->sizeHint() + QSize(3,3));
    gridlayout->addWidget(w_rounded_edges, 8, 0);
    gridlayout->addMultiCellWidget(label, 8, 8, 1, 2);

    gridlayout->setColStretch(2, 1);
    gridlayout->setRowStretch(9, 1);

    toplayout->addWidget(l_preview, 1, AlignCenter);
    
    // Control widgets OK and Cancel

    QHBoxLayout *hbox = new QHBoxLayout();
    toplayout->addLayout(hbox);
    hbox->addStretch(1);
    hbox->addWidget(w_okbutton);
    hbox->addSpacing(8);
    hbox->addWidget(w_cancelbutton);

    toplayout->activate();
    resize(0,0); // Make as small as possible.
}

void LookInfoDialog::somethingChanged(const char *)
{
    somethingChanged();
}


void LookInfoDialog::somethingChanged()
{
    w_layouttext  ->setEnabled(w_text_layout->isChecked());
    w_textcolor   ->setEnabled(w_text_layout->isChecked());
    l_textcolor   ->setEnabled(w_text_layout->isChecked());
    w_image_button->setEnabled(w_image_layout->isChecked());

    l_preview->setMinimumSize(mml->rectWithBorder().size() + QSize(0, 10));

    LookInfo new_look;
    getNewLook(new_look);
    l_preview->setPixmap(mml->preview(&new_look, l_preview->size()));
}


void LookInfoDialog::getNewLook(LookInfo& new_look)
{
    new_look.name           = w_name           ->text();
    new_look.description    = w_description    ->text();
    new_look.text_layout    = w_text_layout    ->isOn();
    new_look.image_layout   = w_image_layout   ->isOn();
    new_look.separators     = w_separators     ->isOn();
    new_look.threed_border  = w_threed_borders ->isOn();
    new_look.rounded_edges  = w_rounded_edges  ->isOn();
    new_look.backgroundcolor= fromQ(w_backgroundcolor->color());
    new_look.textcolor      = fromQ(w_textcolor      ->color());
    new_look.layout_text    = w_layouttext->text();
    new_look.image          = new_lipixmap;
}

void LookInfoDialog::readOldSettings()
{
    w_name           ->setText(old_look.name.c_str());
    w_description    ->setText(old_look.description.c_str());
    w_text_layout    ->setChecked(old_look.text_layout);
    w_image_layout   ->setChecked(old_look.image_layout);
    w_separators     ->setChecked(old_look.separators);
    w_threed_borders ->setChecked(old_look.threed_border);
    w_rounded_edges  ->setChecked(old_look.rounded_edges);
    w_backgroundcolor->setColor  (toQ(old_look.backgroundcolor));
    w_textcolor      ->setColor  (toQ(old_look.textcolor));
    w_layouttext     ->setText   (old_look.layout_text.c_str());

    if (old_look.image.imagesize) {
	new_pixmap   = toQ(old_look.image);
	new_lipixmap = old_look.image; // Copies data :-(
    }
}

void LookInfoDialog::loadImage()
{
    filedialog.rereadDir();
    filedialog.show();
    if (filedialog.result()) 
    {
	FILE *file = 0;
	file = fopen((const char *)filedialog.selectedFile(), "r");
	if (file) {
	    fseek(file, 0, SEEK_END);
	    long size = ftell(file);
	    fseek(file, 0, SEEK_SET);
	    unsigned char *buffer = new unsigned char[size];
	    long read_bytes = fread(buffer, size, 1, file);
	    if (read_bytes != 1) {
		KMsgBox::message(this, "Error loading file",
				 "I couldn't read all of the file.\n",
				 KMsgBox::EXCLAMATION);
		delete buffer;
	    }
	    else {
		QPixmap pixmap;
		pixmap.loadFromData(buffer, size);
		if (pixmap.isNull()) {
		    KMsgBox::message(this, "Can't load image",
				     "This is not an image in\nany format I understand.\nSorry.",
				     KMsgBox::EXCLAMATION);
		    delete buffer;
		}
		else {
		    new_lipixmap.setImage(buffer, size);
		    new_pixmap = pixmap;
		    somethingChanged();
		}
	    }
	}
	else {
	    KMsgBox::message(this, "Can't open file",
			     "There is no file with this name.\n",
			     KMsgBox::EXCLAMATION);
	}
    }
}


void LookInfoDialog::resizeEvent(QResizeEvent *)
{
    LookInfo new_look;
    getNewLook(new_look);
    l_preview->setPixmap(mml->preview(&new_look, l_preview->size()));  
}
