// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/SoundCacheKey.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************
// -*- c++ -*-

#ifndef SoundCacheKey_h
#define SoundCacheKey_h

#include "Metainfo.h"

struct SoundCacheKey
{
  long time;
  Parameterset parameterset;
public:
  SoundCacheKey(long t, const Parameterset &p) : time(t), parameterset(p) {};
  int comparedTo(const SoundCacheKey& key) const;
  bool hasSameParametersetAs(const SoundCacheKey& key) const 
    { return parameterset.comparedTo(key.parameterset) == 0;  };
};


inline int SoundCacheKey::comparedTo(const SoundCacheKey& key) const 
{
  if (time != key.time) return time-key.time;
  else return parameterset.comparedTo(key.parameterset);
}


#endif // SoundCacheKey_h
