/***************************************************************************
                          conf.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// conf.cpp
// ktuner v0.5, by Carl van Schaik
// e-mail carl@leg.uct.ac.za
//
// Radiotrack II implementation : Leendert Meyer (leendert@usa.net).
//
// RadioTrack II Protocol : Ben Pfaff

#ifndef CONF_CPP
#define CONF_CPP

#include "conf.h"
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <kapp.h>

configFile::configFile()
{
  numMore=0;
  basePort=0;
  cardType=NONE;

  for(int i=0;i<100;i++)
    moreName[i]=NULL;

  defaultChannel=0;
  noVolumeSet=0;
  noDefaultSet=0;
  sleepT=0;
  volume=7;
  guiStyle=MotifStyle;

  alarmHr = 0;
  alarmMin = 0;
  alarmSet = 0;

  int ii;
  for (ii=0;ii<9;ii++)
    {
      setFreq(ii,0);
      channelName[ii] = new char[9];
      strcpy(channelName[ii],"--");
    }

  conf = kapp->getConfig();
  if(conf == NULL) {
    printf("KConfig error ??\n");
    kapp->quit();
  }

}

char* doName(char* n)
{
  char* m = new char[strlen(n)];
  strcpy (m,n);
  for (int p=0;p<strlen(m);p++)
    if (m[p] == ' ') m[p] = '_';
  return m;
}

int configFile::save()
{
  newsave();
  return 0;
}

void configFile::newsave()
{
  QString str1,str2,str3;
  conf->setGroup("Options");
  conf->writeEntry("verbose",verbose);
  conf->writeEntry("basePort",basePort);
  conf->writeEntry("cardType",cardType);
  if (cardType == RADIOTRACK)
    conf->writeEntry("cardType","rtrack");
  else if (cardType == RADIOTRACKII)
    conf->writeEntry("cardType","rtrackII");
  else if (cardType == ZOLTRIX)
    conf->writeEntry("cardType","zoltrix");
  else if (cardType == KERNELDEV)
    conf->writeEntry("cardType","kerneldev");

  conf->writeEntry("volume",volume);
  conf->writeEntry("defaultChannel",defaultChannel);
  conf->writeEntry("noVolSet",noVolumeSet);
  conf->writeEntry("noDefSet",noDefaultSet);
  conf->writeEntry("sleepTime",sleepT);
  conf->writeEntry("alarmHour",alarmHr);
  conf->writeEntry("alarmMin",alarmMin);
  conf->writeEntry("alarmSet",alarmSet);

  conf->setGroup("Channels");
  conf->writeEntry("numChannels",9+numMore);

  for (int ch=0;ch<(9+numMore);ch++)
    {
      str1.sprintf("channel%i",ch);
      str2.sprintf("frequency%i",ch);
      str3.sprintf("%i",getFreq(ch));
      conf->writeEntry(str1,getName(ch));
      conf->writeEntry(str2,str3);
    }
  conf->sync();
}

void configFile::newread()
{
  conf->setGroup("Options");
  verbose = conf->readBoolEntry("verbose",FALSE);
  basePort = conf->readNumEntry("basePort",0x20f);

  char *temp = new char[50];
  strcpy(temp,conf->readEntry("cardType","rtrack"));
  if (strcasecmp(temp,"rtrack") == 0)
    cardType=RADIOTRACK;
  else
  if (strcasecmp(temp,"rtrackII") == 0)
    cardType=RADIOTRACKII;
  else
    if (strcasecmp(temp,"zoltrix") == 0)
      cardType=ZOLTRIX;
    else
      if (strcasecmp(temp,"kerneldev") == 0)
	cardType=KERNELDEV;
      else
	{
	  conf->writeEntry("cardType","kerneldev");
	  cardType=KERNELDEV;
	}

  volume = conf->readNumEntry("volume",7);
  defaultChannel = conf->readNumEntry("defaultChannel",0);
  noVolumeSet = conf->readBoolEntry("noVolSet",TRUE);
  noDefaultSet = conf->readBoolEntry("noDefSet",TRUE);
  sleepT = conf->readNumEntry("sleepTime",0);
  alarmHr = conf->readNumEntry("alarmHour",0);
  alarmMin = conf->readNumEntry("alarmMin",0);
  alarmSet = conf->readBoolEntry("alarmSet",FALSE);

  conf->setGroup("Channels");
  numMore = conf->readNumEntry("numChannels",9) - 9;
  moreFreq = new int[numMore+1];

  QString str1;
  for (int ch=0;ch<(9+numMore);ch++)
    {
      str1.sprintf("channel%i",ch);
      setName(ch,conf->readEntry(str1,"--"));
      str1.sprintf("frequency%i",ch);
      setFreq(ch,conf->readNumEntry(str1,0));
    }
}

int configFile::readin()
{
  newread();
  return 0;
}

int configFile::getFreq(int n)
{
  if ((n <=8) && (n >= 0))
    {
      return channelFreq[n];
    }
  else if ((n-8) <= numMore)
    {
      return moreFreq[n-9];
    }
  else return 0;
}

char* configFile::getName(int n)
{
  if ((n <=8) && (n >= 0))
    {
      return channelName[n];
    }
  else if ((n-8) <= numMore)
    {
      return moreName[n-9];
    }
  else return "--";
}

int configFile::getNumMoreChannels()
{
  return numMore;
}

int configFile::getBasePort()
{
  return basePort;
}

int configFile::getDefault()
{
  return defaultChannel;
}

void configFile::setFreq(int n, int f)
{
  if ((f >= 0) && (f <= 440))
      {
	if ((n < 9) && (n >= 0))
	  {
	    channelFreq[n] = f;
	  }
	else if ((n-8) <= numMore)
	  {
	    moreFreq[n-9] = f;
	  }
      }
}

void configFile::setName(int n, const char* Name)
{
  if ((n < 9) && (n >= 0))
    {
      if (channelName[n] != NULL) delete channelName[n];

      channelName[n] = new char[strlen(Name)+1];
      strcpy(channelName[n],Name);
    }
  else if ((n-8) <= numMore)
    {
      if (moreName[n-9] != NULL) delete moreName[n-9];

      moreName[n-9] = new char[strlen(Name)+1];
      strcpy(moreName[n-9],Name);
    }
}

void configFile::insChannel(int pos)
{
  int tem;
  if (pos < (9+numMore))
    {
      numMore++;
      for (tem=(8+numMore);tem>pos;tem--)
	{
	  setName(tem,getName(tem-1));
	  setFreq(tem,getFreq(tem-1));
	}
      setName(pos,"--");
      setFreq(pos,0);
    }
  else
    if (pos == (9+numMore))
      {
	numMore++;
	setName(pos,"--");
	setFreq(pos,0);
      }
}

void configFile::delChannel(int pos)
{
  int tem, tem2=0;
  if (pos < (9+numMore))
    {
      if (numMore == 0) tem2 = 1;
      if (numMore > 0) numMore--;
      for (tem=pos;tem<(8+numMore);tem++)
	{
	  setName(tem,getName(tem+1));
	  setFreq(tem,getFreq(tem+1));
	}
      if (tem2)
	{
	  setName(8,"--");
	  setFreq(8,0);
	}
    }
  else
    if (pos == (9+numMore))
      {
	numMore--;
      }
}

void configFile::setBasePort(int P)
{
  basePort = P;
}

void configFile::setDefault(int n)
{
  if ((n >= 0) && (n < (9+numMore)))
    defaultChannel = n;
}

void configFile::setVolume(int n)
{
  if ((n>=0) && (n<=16))
    volume=n;
}

int configFile::getVolume()
{
  return volume;
}

bool configFile::getVerbose()
{
  return verbose;
}

void configFile::setVerbose(bool v)
{
  verbose = v;
}

int configFile::noVolSet()
{
  return noVolumeSet;
}

void configFile::setNoVolSet(int n)
{
  noVolumeSet = n;
}

int configFile::noDefSet()
{
  return noDefaultSet;
}

void configFile::setNoDefSet(int n)
{
  noDefaultSet = n;
}

CardType configFile::getCardType()
{
  return cardType;
}

void configFile::setCardType(CardType c)
{
  cardType = c;
}

GUIStyle configFile::gui()
{
  return guiStyle;
}

void configFile::setGui(GUIStyle s)
{
  guiStyle = s;
}

int configFile::getSleepTime()
{
  return sleepT;
}

void configFile::setSleepTime(int t)
{
  if ((t >0) && (t<500))
      {
	sleepT = t;
      }
}

void configFile::delSlashN(char* wrd)
{
   //int h,i = strlen(wrd);
   //for (h=0;h<i;h++)
   //     if (wrd[h]='\n') wrd[h]=' ';
}

int configFile::getAlarmHr()
{
  return alarmHr;
}

void configFile::setAlarmTime(int Hr,int Min)
{
  if ((alarmHr >= 0) && (alarmHr < 24) && (alarmMin >=0) && (alarmMin < 60))
    {
      alarmHr = Hr;
      alarmMin = Min;
    }
}

int configFile::getAlarmMin()
{
  return alarmMin;
}

int configFile::setAlarm()
{
  return alarmSet;
}

void configFile::setAlarmDef(int i)
{
  if (i)
    alarmSet = 1;
  else
    alarmSet = 0;
}

#endif
