	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "synthmodule.h"

string SynthModule::getArgument(int nr, ArgType direction)
{
	string result, arglist = getParams();
	int wanted = nr, have = 0, i;

	if(direction == arg_out)
		wanted += 512;	// second string of args behind ';'
						// more than 512 arguments currently unsupported ;)

	for (i=0;i<arglist.length();i++)
	{
		switch(arglist[i])
		{
			case ',': have++;
				break;
			case ';': have += 512 - (have & 511);
				break;
			default:  if(have == wanted) result += arglist[i];
				break;
		}
	}
	return(result);
};

void SynthModule::ProcessData(string data)
{
	fprintf(stderr,"data could not be processed by %s\n",getName().c_str());
}

void SynthModule::DeInitialize()
{
	// do nothing
}

void SynthModule::getfds(int &infd, int &outfd)
{
	// if we are an io performing module (midi event processing, sound output,
    // ..., we are likely to open out files here and return them to the
    // synthesizer, which will perform scheduling if io is to do

	// setting fds to -1 means, we don't have them

    infd = -1;   // no input performed by this module
	outfd = -1;  // no output performed by this module
}

void *SynthModule::get_MS()
{
	static ModuleServer<SynthModule> *MS = 0;
	if(!MS)
	{
		MS = new ModuleServer<SynthModule>;
#ifndef MODULESERVER_DEBUG
	}
#else
		printf("Creating a ModuleServer for SynthModules\n");
	}
	else
	{
		printf("Obtaining a ModuleServer reference for SynthModules\n");
	}
	printf("ModuleServer is at %lx\n",MS);
#endif

	return(MS);
}

SynthModule::~SynthModule()
{
	// this is here to avoid the compiler warning ;)
}
