	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include <sys/types.h>
#include <sys/time.h>
#include <math.h>
#include <stdio.h>
#include <ctype.h>
#include <strings.h>
#include <unistd.h>
#include <stdlib.h>
#include <malloc.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "synth_impl.h"

#include <fcntl.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

void rt_error()
{
  	fprintf(stderr," This means that this program will likely not be able\n");
  	fprintf(stderr," to produce acceptable sound (without clicks and breaks).");
	fprintf(stderr,"\n\n");
}

#ifdef HAVE_REALTIME_SCHED
#include <sched.h>

void adjust_priority()
{
	int sched = sched_getscheduler(0);
	if(sched == SCHED_FIFO || sched == SCHED_RR)
	{
		printf(">> since the scheduling policy is not standard, I assume\n");
		printf("   it has been adjusted to fit the needs of realtime audio\n");
	}
	else
	{
		struct sched_param sp;

		sp.sched_priority = 40;

		if(sched_setscheduler(0, SCHED_FIFO, &sp) == 0)
		{
			printf(">> running as realtime process now\n");
		}
		else
		{
			fprintf(stderr,"\nWARNING: Can't get realtime priority ");
			fprintf(stderr," (try running as root)!\n");
			rt_error();
		}
	}
}
#else
void adjust_priority()
{
	int prio;

	prio = getpriority(PRIO_PROCESS,getpid());
	if(prio < -10)
	{
		setpriority(PRIO_PROCESS,getpid(),-17);
		prio = getpriority(PRIO_PROCESS,getpid());
	}

  	fprintf(stderr,
		"\nWARNING: Your system doesn't support realtime scheduling.\n");
	rt_error();

	if(prio > -10) {
		printf(">> synthesizer priority is %d (which is unacceptable,",prio);
		printf(" try running as root)\n");
	}
	else {
		printf(">> synthesizer priority is %d (which is the best\n",prio);
		printf("   we can get out of a non realtime system)\n");
	}
}
#endif

main(int argc, char **argv)
{
	adjust_priority();

	CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "mico-local-orb");
    CORBA::BOA_var boa = orb->BOA_init (argc, argv, "mico-local-boa");

	KSynthesizer_impl *server = new KSynthesizer_impl(&orb);

	boa->impl_is_ready( CORBA::ImplementationDef::_nil() );
	orb->run();

	CORBA::release(server);
	return 0;
}
