	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "utils.h"

/*#define FILTER*/

#define NMAX 128
/*44100*/

main(int argc, char **argv)
{
	int audiofd = sound_open();
	int n,nmax;
	int syn;
	char sb[2*NMAX];
	unsigned char aiin[2*NMAX];
	float msv,sv,amx=0.01,oamx=0;
	int samplingrate=44100;
	int byteorder = get_byteorder();

	if(byteorder == ORDER_UNKNOWN)
	{
		fprintf(stderr,"Can't determine the byteorder of your system.\n");
		exit(0);
	}
	if(argc>1) {
		amx = atof(argv[1]);
	}
	if(argc>2) {
		samplingrate = atoi(argv[2]);
	}
	sound_init(audiofd,samplingrate,0);

	do
	{
		nmax = fread(aiin,1,2*NMAX,stdin)/2;
		for (n=0;n<nmax;n++)
		{
			long l;
			unsigned char c;

			c=aiin[n*2+1]+128;
			l=c*256+aiin[n*2+0]-32767;
	
			sv = (float)l/(float)32768;
			if(sv > oamx) {oamx=sv;}
			if(sv > amx) {amx=sv;}
			syn = sv/amx*(128*256-1);
			syn = syn+65536;
			if(byteorder == ORDER_BIGENDIAN)
			{
				sb[n*2+0] = syn / 256;
				sb[n*2+1] = syn % 256;
			}
			else
			{
				sb[n*2+0] = syn % 256;
				sb[n*2+1] = syn / 256;
			}
			if(sv > msv) msv=sv;
			if(-sv > msv) msv=-sv;
			if((n&16383)==0) 
			{
				/*printf("msv = %f\n",msv);*/
				msv = 0;
			}
		}
		sound_write(audiofd,sb,2*nmax);
	}	while(nmax != 0);
	sound_close(audiofd);
	fprintf(stderr,"amx is %f ; oamx = %f\n",amx,oamx);
}
