	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include <fcntl.h>
#include <stdio.h>
#include <termios.h>

int main(int argc, char **argv)
{
	char *midiport = "/dev/midi00";
	int midi;
	int count,i;
	char buffer[128];
	struct termios termios_p;

	if(argc > 1) {
		midiport = argv[1];
	}
	fprintf(stderr,"This program will echo the hex data of every byte that\n");
	fprintf(stderr,"arrives on your midi in channel (%s)\n",midiport);

	midi = open(midiport,O_RDONLY);
	if(!midi) {
		fprintf(stderr,"Error: can't open midi device for reading...\n");
		exit(1);
	}

	while((count = read(midi,&buffer,sizeof(buffer))) > 0)
	{
		for (i = 0;i<count;i++)
		{
			printf(" < ");

			//if(buffer[i] != 0)
				printf(" %02x",buffer[i] & 0xff);

			printf(" > ");
			fflush(stdout);
		}
	}
	exit(0);
}
