/* $Id: stereoview.h,v 1.2 1999/04/23 21:49:55 philipp Exp $ */

#ifndef __STEREOVIEW_H
#define __STEREOVIEW_H

#include <qwidget.h>
#include <qstring.h>

#include "stereoscope.h"
#include "korranzeige.h"

class StereoView : public QWidget {
  Q_OBJECT
    
 public:
  StereoView(QWidget* parent=0, const char* name=0, const char*
	      device="/dev/dsp", unsigned int r=44100, unsigned int
	      i=5, unsigned int l=2000);
  ~StereoView();
  void setzeIntervall(unsigned int);
  int setzeRate(unsigned int);
  void setzePunktLog(unsigned int);
  int setzeDevice(const char*);

 protected:
  void timerEvent(QTimerEvent*);

 private:
  int fd, timer;
  unsigned char *buffer;
  unsigned int maxpunkte, rate, intervall, punktzeiger;
  void realloc_buffers();
  void alloc_buffers();
  StereoScope* scope;
  KorrAnzeige* kanzeige;
  QString devicename;
  int openDevice(const char*);
};

#endif
