/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998-2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#include "ksrndprefs.h"
#include "ksrndprefs.moc"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <stdlib.h>
#include <string.h>

#include <qsize.h>
#include <qlabel.h>
#include <qdialog.h>
#include <qwidget.h>
#include <qlined.h>	// <qlineedit.h>
#include <qpushbt.h>	// <qpushbutton.h>
#include <qtooltip.h>
#include <qlayout.h>

#include <kapp.h>

#include "ksrndwidget.h"
#include "ksrndprefs.h"
#include "ksrndsetup.h"
#include "dockwidget.h"


extern KApplication * mykapp;


KSrndPrefs::KSrndPrefs( QWidget * parent, const char * name ) : QDialog ( parent, name )
{
	QLabel *label1, *label2;
	QPushButton *ok, *def, *apply, *cancel;
	QBoxLayout *hbox, *vbox;
	QGridLayout *grid;
	int width;

	gotToolTips = FALSE;
	device_buf = 0;
	mixer_buf = 0;

	KsConfig = mykapp->getConfig();

	vbox = new QVBoxLayout( this, 8 );

	vbox->addStretch( 10 );
	
	grid = new QGridLayout( 2, 2, 10 );
	vbox->addLayout( grid );

	label1 = new QLabel( i18n("SRND &Device:"), this );
	label1->setFixedSize( label1->sizeHint() );
	grid->addWidget( label1, 0, 0, AlignLeft | AlignVCenter );

	device = new QLineEdit( this );
	label1->setBuddy( device );
	device->setFixedHeight( device->sizeHint().height() );
	grid->addWidget( device, 0, 1, AlignVCenter );

	label2 = new QLabel( i18n("&Mixer Command:"), this );
	label2->setFixedSize( label2->sizeHint() );
	grid->addWidget( label2, 1, 0, AlignLeft | AlignVCenter );

	mixer = new QLineEdit( this );
	label2->setBuddy( mixer );
	mixer->setFixedHeight( device->sizeHint().height() );
	grid->addWidget( mixer, 1, 1, AlignVCenter );
	
	grid->setColStretch( 0, 0 );
	grid->setColStretch( 1, 1 );

	vbox->addStretch( 10 );

	grid = new QGridLayout( 3, 2, 10 );
	vbox->addLayout( grid );

	tooltips = new QCheckBox( i18n("Show Tooltips"), this );
	tooltips->setMinimumSize( tooltips->sizeHint() );
	grid->addWidget( tooltips, 0, 0 );
	
	menubar = new QCheckBox( i18n("Show &Menubar"), this );
	menubar->setMinimumSize( menubar->sizeHint() );
	grid->addWidget( menubar, 1, 0 );

	toolbar = new QCheckBox( i18n("Show &Toolbar"), this );
	toolbar->setMinimumSize( toolbar->sizeHint() );
	grid->addWidget( toolbar, 2, 0 );

	docking = new QCheckBox( i18n("&Allow Docking"), this );
	docking->setMinimumSize( docking->sizeHint() );
	grid->addWidget( docking, 0, 1 );
	connect( docking, SIGNAL(clicked()), SLOT(dockedSlot()) );

	startdocked = new QCheckBox( i18n("Start Docked"), this );
	startdocked->setMinimumSize( startdocked->sizeHint() );
	grid->addWidget( startdocked, 1, 1 );

	save = new QCheckBox( i18n("&Save Main Settings on Exit"), this );
	save->setMinimumSize( save->sizeHint() );
	grid->addWidget( save, 2, 1 );

	grid->setColStretch( 0, 1 );
	grid->setColStretch( 1, 1 );
	grid->setRowStretch( 0, 1 );
	grid->setRowStretch( 1, 1 );
	grid->setRowStretch( 2, 1 );

	vbox->addStretch( 10 );

	ok = new QPushButton( i18n("OK"), this );
	ok->setDefault( TRUE );
	width = ok->sizeHint().width();

	def = new QPushButton( i18n("Default"), this );
	if (def->sizeHint().width() > width)
		width = def->sizeHint().width();

	apply = new QPushButton( i18n("Apply"), this );
	if (apply->sizeHint().width() > width)
		width = apply->sizeHint().width();

	cancel = new QPushButton( i18n("Cancel"), this );
	if (cancel->sizeHint().width() > width)
		width = cancel->sizeHint().width();

	ok->setFixedSize( width, ok->sizeHint().height() );
	def->setFixedSize( width, def->sizeHint().height() );
	apply->setFixedSize( width, apply->sizeHint().height() );
	cancel->setFixedSize( width, cancel->sizeHint().height() );

	hbox = new QHBoxLayout( 8 );
	vbox->addLayout( hbox );

	hbox->addStretch( 8 );
	hbox->addWidget( ok );
	hbox->addWidget( def );
	hbox->addWidget( apply );
	hbox->addWidget( cancel );
	
	vbox->activate();

	connect( ok, SIGNAL(clicked()), SLOT(accept()) );
	connect( def, SIGNAL(clicked()), SLOT(reset()) );
	connect( apply, SIGNAL(clicked()), SLOT(apply()) );
	connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

	setCaption( i18n("KSrnd Preferences") );

	resize( 400, 200 );
}


KSrndPrefs::~KSrndPrefs()
{
	if (device_buf != 0)
		free(device_buf);
	if (mixer_buf != 0)
		free(mixer_buf);
}


void KSrndPrefs::addToolTips(bool on)
{
	if (on == gotToolTips)
		return;

	gotToolTips = on;

	if (gotToolTips) {
		QToolTip::add( device, i18n("Device of the miroMEDIA Surround Board") );
		QToolTip::add( mixer, i18n("Mixer Command") );
		QToolTip::add( tooltips, i18n("Show Tooltips in Dialogs") );
		QToolTip::add( menubar, i18n("Show Menubar in Main Dialog") );
		QToolTip::add( toolbar, i18n("Show Toolbar in Main Dialog") );
		QToolTip::add( docking, i18n("Allow Docking to KPanel") );
		QToolTip::add( startdocked, i18n("Start minimized if Docking is allowed") );
		QToolTip::add( save, i18n("Save Settings of Main Window on Exit") );
	}
	else {
		QToolTip::remove( device );
		QToolTip::remove( mixer );
		QToolTip::remove( tooltips );
		QToolTip::remove( menubar );
		QToolTip::remove( toolbar );
		QToolTip::remove( docking );
		QToolTip::remove( startdocked );
		QToolTip::remove( save );
	}
}	


char * KSrndPrefs::deviceText()
{
	return device_buf;

}


char * KSrndPrefs::mixerText()
{
	return mixer_buf;

}


bool KSrndPrefs::isToolTips()
{
	return tooltips_buf;
}


bool KSrndPrefs::isMenuBar()
{
	return menubar_buf;
}


bool KSrndPrefs::isToolBar()
{
	return toolbar_buf;
}


bool KSrndPrefs::isDocking()
{
	return docking_buf;
}


bool KSrndPrefs::startDocked()
{
	return startdocked_buf;
}


bool KSrndPrefs::isSave()
{
	return save_buf;
}


void KSrndPrefs::accept()
{
	apply();
	hide();
}


void KSrndPrefs::reset()
{
	if (device_buf != 0)
		free(device_buf);
	if (mixer_buf != 0)
		free(mixer_buf);

	KsConfig->setGroup("Main");

	device_buf = strdup(KsConfig->readEntry( "Device", "/dev/srnd" ));
	device->setText( device_buf );
	mixer_buf = strdup(KsConfig->readEntry( "Mixer", "kmix") );
	mixer->setText( mixer_buf );
	tooltips_buf = KsConfig->readBoolEntry( "ToolTips", TRUE );
	tooltips->setChecked( tooltips_buf );
	menubar_buf = KsConfig->readBoolEntry( "ShowMenuBar", TRUE );
	menubar->setChecked( menubar_buf );
	toolbar_buf = KsConfig->readBoolEntry( "ShowToolBar", TRUE );
	toolbar->setChecked( toolbar_buf );
	docking_buf = KsConfig->readBoolEntry( "Docking", TRUE );
	docking->setChecked( docking_buf );
	startdocked_buf = KsConfig->readBoolEntry( "StartDocked", FALSE );
	startdocked->setChecked( startdocked_buf );
	save_buf = KsConfig->readBoolEntry( "SaveOnExit", TRUE );
	save->setChecked( save_buf );

	dockedSlot();
}


void KSrndPrefs::apply()
{
	if (device_buf != 0)
		free(device_buf);
	if (mixer_buf != 0)
		free(mixer_buf);

	KsConfig->setGroup( "Main" );

	device_buf = strdup(device->text());
	KsConfig->writeEntry( "Device", device_buf );
	mixer_buf = strdup(mixer->text());
	KsConfig->writeEntry( "Mixer", mixer_buf );

	tooltips_buf = tooltips->isChecked();
	KsConfig->writeEntry( "ToolTips", tooltips_buf );
	menubar_buf = menubar->isChecked();
	KsConfig->writeEntry( "ShowMenuBar", menubar_buf );
	toolbar_buf = toolbar->isChecked();
	KsConfig->writeEntry( "ShowToolBar", toolbar_buf );
	docking_buf = docking->isChecked();
	KsConfig->writeEntry( "Docking", docking_buf );
	KsConfig->writeEntry( "StartDocked", startdocked->isChecked() );
	save_buf = save->isChecked();
	KsConfig->writeEntry( "SaveOnExit", save_buf );

	KsConfig->sync();

	emit apply_clicked();
}


void KSrndPrefs::dockedSlot()
{
	startdocked->setEnabled( docking->isChecked() );
}
