/***************************************************************************
                          afx.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __AUDIOFX__
#define __AUDIOFX__

//#include <qstring.h>

#include "csample.h"
#include "ccomplex.h"

#include <math.h>
#include <stdlib.h>
#include <stdio.h>

#ifndef SIGN
#define SIGN(a)		((a) == 0?0:((a) < 0?-1:1))
#endif


class CAFX
{
public:
	CAFX(){};

	double	afxfn(double x,QArray<double> points,int sym);
	double	afxcompress(double x,double level);
	double	afxexpand(double x,double level);

	double	getProgress() {return progress;};
	QString	getModule() {return module;};

	void		deeppass(CSample *s,double,double,uint pos,uint len);
	void		highpass(CSample *s,double,double,uint pos,uint len);
	double	calcDCOffset(CSample *s,int pos,uint len);
	void		optimizeDCOffset(CSample *smp,int pos,uint len);
	void		offsetDC(CSample *smp,double offset,int pos,uint len);
	double	calcVolume(CSample *smp,int pos,uint len);
	void		volume(CSample *smp,int pos,uint len);
	void		volume(CSample *smp,double vol,int pos,uint len);
	void		volume(CSample *smp,QArray<double> points,int pos,uint len);
	void		echo(CSample *smp,double delay,double volume,double release,uint pos,uint len);
	void		reverb(CSample *smp,double delay,double volume,double mix,uint pos,uint len);
	void		fuzz(CSample *smp,double volume,double cut,int side,uint pos,uint len);
	void		hull(CSample *smp,uint pos,uint len);
	void		noiseGate(CSample *smp,double treshhold,uint pos,uint len);
	void		distortion(CSample *smp,QArray<double> points,int symmetric,uint pos,uint len);
	void		compress(CSample *smp,double level,uint pos,uint len);
	void		expand(CSample *smp,double level,uint pos,uint len);

#ifdef undefined
  /** Shifts the pitch by shiftfactor. */
  void		shiftpitch(CSample *s,double shiftfactor,uint,uint);
	/** Takes a pitch out. */
	void		takepitch(CSample *smp,int pitchnm,uint,uint);
#endif

	void		fft(CComplex *c,int size);
	void		ifft(CComplex *c,int size);
	void		transform(CComplex *c,int n,bool forward);
	void		inversion(CComplex *c,int n);	
  /** blurs the sample */
  void blur(CSample*,double size,uint pos, uint len) ;
		
protected:
	double		progress;
	QString	module;

};


#endif













