// Sound recorder 0.05 Aug 01 1998, GPL 2 (see COPYRIGHTS)
// 1997, 1998  B. Warmerdam

/* class definition of the cd-player */

/* Created on: December 9 1997       */

#ifndef _cd_player_h
#define _cd_player_h

#include <unistd.h>
#include <stdio.h>
#include <iostream.h>
#include <string.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/cdrom.h>
#include <exception>

#define ERROR perror

enum eDeviceType { UnknownDevice, IdeDevice, ScsiDevice };

class CDplayer{

	public:

		class	CDtrack{
			private:
					int		tracknr, indexnr;
					int		starttime, stoptime, currenttime;
			public:
					const int	track() const;
					const int	index() const;
					const int	timeElapsed() const;
					const int	timeRemaining() const;

					void		setTrack(const int track, const int index);
					void		setCurrenttime(const int min, const int sec);
					void		setTrackTimes(const int start, const int stop);
		};

					CDplayer();
					~CDplayer();

		int			ready();
		int			open();
		void			close();

		void			getPlayingTrack(CDplayer::CDtrack & track);
		void			play(const unsigned track0, const unsigned play_index0,
					     const unsigned track1, const unsigned play_index1,
					     const unsigned start_time_offset);
		void			play(const unsigned track0 = 1, const unsigned track1 = 0);
		void			play(const unsigned track0 = 1, const unsigned track1 = 0,
					     const unsigned start_time_offset = 0);
		void			stop();
		void			pause();
		void			eject();

		int			isAudioTrack(int c_track);
		const bool		hasCDrom();
		int			audio_status();
		void			setDevice(const char * deviceName);
		unsigned		firstTrack(){ return track0;}
		unsigned		lastTrack(){ return track1;}

		const unsigned long	getDiscId() const;
		void			getTrack(CDplayer::CDtrack & track, const unsigned tracknr);
		const eDeviceType	getCurrentDeviceType();

	private:
		int			defaultDeviceUseage, cdrom_fd;
		unsigned		track0, track1, index0, index1, total_time;

		int			startTimes[100];
		int			startFrames[100];

		long int		discId;

		static const char *	defaultDeviceName;
		char *			currentDeviceName;

		int			open(const char * deviceName);
		void			error(const char * indication, 
					      char * file, int line, char * func);
		void			readSubChannel(struct cdrom_subchnl & subchnl);
		void			readTocEntry(const int track, const int format, 
						     struct cdrom_tocentry & tocentry);
		void			readTimes();
		int			cddb_sum(int trackTime);
		void			calculateDiscId();
};

#endif
