/***************************************************************************
                          optionsdata.cpp.cpp  -  description
                             -------------------
    begin                : Sat Feb 5 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qtooltip.h>
#include "options.h"


void  options::initDialog(){

  QFont qf_little("Helvetica",10,QFont::Normal);

  this->setFixedSize(350,400);
  this->setMinimumSize(350,400);
  this->setCancelButton();
  this->setApplyButton();

  general = new QWidget();
  rec = new QWidget();
  mp3 = new QWidget();

	box_rec = new QHBoxLayout(rec,5,5);
	
	/* mp3 */
	box_bitrate = new QGroupBox(mp3,"Bitrate");
	box_bitrate->setGeometry(10,10,160,155);
	box_bitrate->setTitle("Bitrate");
	bitrate_slider = new KSlider(1,18,1,12,QSlider::Horizontal,mp3,"Bitrate");
  bitrate_slider->setGeometry(20,82,120,50);
  vbr = new QCheckBox("Variable Bitrate",mp3);
  vbr->setGeometry(20,105,120,30);
  vbr_slider = new KSlider(0,9,1,4,QSlider::Horizontal,mp3,"VBR - Quality");
	vbr_slider->setGeometry(20,137,90,20);
	QToolTip::add (vbr_slider,i18n("0=high quality,bigger files 9=smaller files"));
	
	fast = new QCheckBox("Fast encoding\n(Low Quality)",mp3);
  fast->setMinimumSize(130,17);
  fast->move(190,10);
  voice = new QCheckBox("experimental\nvoice mode",mp3);
  voice->setMinimumSize(130,17);
  voice->move(190,50);
  quality = new QCheckBox("use (maybe)\nquality improvements",mp3);
  quality->setMinimumSize(130,17);
  quality->move(190,90);
  checksum = new QCheckBox("error protection\nadds 16bit checksum\nto every frame",mp3);
  checksum->setMinimumSize(140,50);
  checksum->move(190,130);
  copyright = new QCheckBox("mark as copyright",mp3);
  copyright->setMinimumSize(130,17);
  copyright->move(190,180);
  non_original = new QCheckBox("mark as\nnon-original",mp3);
  non_original->setMinimumSize(130,17);
  non_original->move(190,230);
  graphical = new QCheckBox("launch graphical\nanalysis",mp3);
  graphical->setMinimumSize(130,17);
  graphical->move(190,280);

	mp3_mode = new QButtonGroup("Stereomode",mp3);
  mp3_mode->setMinimumSize(160,150);
  mp3_mode->move(10,170);

  mp3_stereo = new QRadioButton("Stereo",mp3_mode);
  mp3_joint = new QRadioButton("Joint Stereo",mp3_mode);
  mp3_force = new QRadioButton("Force ms_stereo",mp3_mode);
  mp3_mono = new QRadioButton("Mono",mp3_mode);

  mp3_mode->insert(mp3_stereo,1);
  mp3_mode->insert(mp3_joint,2);
  mp3_mode->insert(mp3_force,3);
  mp3_mode->insert(mp3_mono,4);

  box_mode = new QVBoxLayout(mp3_mode,20,10);
  box_mode->addWidget(mp3_stereo);
  box_mode->addWidget(mp3_joint);
  box_mode->addWidget(mp3_force);
  box_mode->addWidget(mp3_mono);

  lcd_bitrate = new QLCDNumber(mp3);
  lcd_bitrate->setGeometry(120,50,40,25);
  lcd_bitrate->setNumDigits(3);
  lcd_vbr = new QLCDNumber(mp3);
	lcd_vbr->setGeometry(135,109,20,25);
	lcd_vbr->setNumDigits(1);
	QToolTip::add (lcd_vbr,i18n("0=high quality,bigger files 9=smaller files"));

  label_bitrate = new QLabel(i18n("Constant Bitrate"),mp3);
  label_bitrate->setGeometry(20,50,100,20);
  label_bitrate_freq1 = new QLabel(i18n("32 44.1 48"),mp3);
  label_bitrate_freq1->setGeometry(80,25,60,20);
  label_bitrate_freq1->setFont(qf_little);
  label_bitrate_freq2 = new QLabel(i18n("16 22.05 24"),mp3);
  label_bitrate_freq2->setGeometry(20,25,60,20);
  label_bitrate_freq2->setFont(qf_little);
  label_bitrate_freq3 = new QLabel(i18n("kHz"),mp3);
  label_bitrate_freq3->setGeometry(136,25,20,20);
  label_bitrate_freq3->setFont(qf_little);
	label_vbr = new QLabel(i18n("Quality"),mp3);
	label_vbr->setGeometry(120,136,44,25);
  /* record */
  group_prog = new QButtonGroup("Record Program",rec);
  group_prog->setMinimumSize(60,50);
  group_samplerate = new QButtonGroup("Samlperate",rec);
  group_samplerate->setMinimumSize(60,150);

  soundrecord = new QRadioButton("Sound-Record",group_prog);
  sox = new QRadioButton("Sox (rec/play)",group_prog);
  group_prog->insert(soundrecord,1);
  group_prog->insert(sox,2);
  rate_16 = new QRadioButton("16 kHz",group_samplerate);
  rate_22 = new QRadioButton("22.05 kHz",group_samplerate);
  rate_24 = new QRadioButton("24 kHz",group_samplerate);
  rate_32 = new QRadioButton("32 kHz",group_samplerate);
  rate_44 = new QRadioButton("44.1 kHz",group_samplerate);
  rate_48 = new QRadioButton("48 kHz",group_samplerate);
  group_samplerate->insert(rate_16,16);
  group_samplerate->insert(rate_22,22);
  group_samplerate->insert(rate_24,24);
  group_samplerate->insert(rate_32,32);
  group_samplerate->insert(rate_44,44);
  group_samplerate->insert(rate_48,48);

  box_record = new QVBoxLayout();
  box_rec->addLayout(box_record);
  box_record->addWidget(group_prog);
  box_record->addWidget(group_samplerate);

  box_program = new QVBoxLayout(group_prog,20,10);
  box_program->addWidget(soundrecord);
  box_program->addWidget(sox);

  box_sample = new QVBoxLayout(group_samplerate,20,10);
  box_sample->addWidget(rate_16);
  box_sample->addWidget(rate_22);
  box_sample->addWidget(rate_24);
  box_sample->addWidget(rate_32);
  box_sample->addWidget(rate_44);
  box_sample->addWidget(rate_48);
  //box_sample->activate();

  group_ask = new QButtonGroup("Recored File",rec);
  group_ask->setMinimumSize(60,50);
  group_bit = new QButtonGroup("Bits per sample",rec);
  group_bit->setMinimumSize(60,50);
  group_stereo = new QButtonGroup("Channels",rec);
  group_stereo->setMinimumSize(60,50);

  ask = new QRadioButton("Ask if overwrite",group_ask);
  overwrite = new QRadioButton("Overwrite old File",group_ask);
  neu = new QRadioButton("Write to new filename\n(oldfilename[Nr].wav)",group_ask);
  neu->setMinimumSize(56,17);
  group_ask->insert(ask,1);
  group_ask->insert(overwrite,2);
  group_ask->insert(neu,3);
  bit_8 = new QRadioButton("8-Bit",group_bit);
  bit_16 = new QRadioButton("16-Bit",group_bit);
  group_bit->insert(bit_8,8);
  group_bit->insert(bit_16,16);
  stereo = new QRadioButton("Stereo",group_stereo);
  mono = new QRadioButton("Mono",group_stereo);
  group_stereo->insert(mono,1);
  group_stereo->insert(stereo,2);

  box_stereo_bit = new QVBoxLayout();
  box_rec->addLayout(box_stereo_bit);
  box_stereo_bit->addWidget(group_ask);
  box_stereo_bit->addWidget(group_stereo);
  box_stereo_bit->addWidget(group_bit);

  box_ask = new QVBoxLayout(group_ask,20,10);
  box_ask->addWidget(ask);
  box_ask->addWidget(overwrite);
  box_ask->addWidget(neu);
  box_ask->activate();

  box_stereo = new QVBoxLayout(group_stereo,20,10);
  box_stereo->addWidget(mono);
  box_stereo->addWidget(stereo);
  box_stereo->activate();

  box_bit = new QVBoxLayout(group_bit,20,10);
  box_bit->addWidget(bit_8);
  box_bit->addWidget(bit_16);
  box_bit->activate();

  box_rec->activate();
  /*inster the sigle optionsdialogs in tabdialog */
  //this->addTab(general,"General");
  this->addTab(rec,"Record");
  this->addTab(mp3,"MP3");

}