/***************************************************************************
                          ksoundrecord.cpp  -  description
                             -------------------
    begin                : Don Jan  6 20:17:39 CET 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qmessagebox.h>
#include <qfiledialog.h>

// include files for KDE
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kfiledialog.h>

// application specific includes
#include "ksoundrecord.h"
#include "ksoundrecordview.h"
#include "ksoundrecorddoc.h"
#include "resource.h"


KsoundrecordApp::KsoundrecordApp()
{
  config=kapp->getConfig();
  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initMenuBar();
  initToolBar();
  initStatusBar();
  initKeyAccel();
  initDocument();
  initView();
	
  wav_nr = 0;
  mp3_nr = 0;
  readOptions();
  slot_readMyOptions();


  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar items at startup
  disableCommand(ID_FILE_SAVE);
  disableCommand(ID_FILE_SAVE_AS);
   	
  disableCommand(ID_EDIT_CUT);
  disableCommand(ID_EDIT_COPY);
  disableCommand(ID_EDIT_PASTE);

  //disableCommand(ID_KSR_OPTIONS);
  disableCommand(ID_FILE_OPEN_RECENT);

  /* create instances for console programs*/
  recProc = new KProcess();
  playProc = new KProcess();
  mp3Proc = new KProcess();
  mp3playProc = new KProcess();
	mixProc = new KProcess();
	killSoxProc = new KProcess();
  findsoxProc = new KShellProcess();

  connect(recProc,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(slot_length_label(KProcess*, char*, int)));
	connect(playProc,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(slot_length_label(KProcess*, char*, int)));
  connect(findsoxProc,SIGNAL(receivedStdout(KProcess*, char*, int)),this,SLOT(slot_kill_sox(KProcess*, char*, int)));
  connect(mp3Proc,SIGNAL(receivedStderr(KProcess*, char*, int)),this,SLOT(slot_length_label(KProcess*, char*, int)));
  connect(mp3playProc,SIGNAL(receivedStderr(KProcess*, char*, int)),this,SLOT(slot_length_label(KProcess*, char*, int)));
	connect(recProc,SIGNAL(processExited(KProcess*)),this,SLOT(slotrecstop()));
	connect(playProc,SIGNAL(processExited(KProcess*)),this,SLOT(slotplaystop()));
  connect(mp3Proc,SIGNAL(processExited(KProcess*)),this,SLOT(slotmp3stop()));

  connect(view->output_window->QPushButton_1,SIGNAL(clicked()),this,SLOT(slotViewOutput()));
  connect(view->options_dialog,SIGNAL(applyButtonPressed()),this,SLOT(slot_saveMyOptions()));
  connect(view->options_dialog,SIGNAL(cancelButtonPressed()),this,SLOT(slot_readMyOptions()));

  connect(view->options_dialog->mp3_mode,SIGNAL(clicked(int)),this,SLOT(slot_stereo(int)));	
  connect(view->options_dialog->group_prog,SIGNAL(clicked(int)),this,SLOT(slot_prog(int)));
  connect(view->options_dialog->group_samplerate,SIGNAL(clicked(int)),this,SLOT(slot_rec_samplerate(int)));
  connect(view->options_dialog->group_bit,SIGNAL(clicked(int)),this,SLOT(slot_rec_bits(int)));
  connect(view->options_dialog->group_stereo,SIGNAL(clicked(int)),this,SLOT(slot_rec_stereo(int)));
  connect(view->options_dialog->bitrate_slider,SIGNAL( valueChanged(int)),this,SLOT(slot_bitrate_changed(int)));
  connect(view->options_dialog->vbr_slider,SIGNAL( valueChanged(int)),this,SLOT(slot_vbr_changed(int)));
  connect(view->options_dialog->group_ask,SIGNAL(clicked(int)),this,SLOT(slot_ask_opt(int)));

  connect(view->file_list->open_files,SIGNAL(clicked()),this,SLOT(slot_add_filesnames()));
  connect(view->file_list->del_files,SIGNAL(clicked()),this,SLOT(slot_remove_files()));
  connect(view->file_list->close_filelist,SIGNAL(clicked()),this,SLOT(slot_hide_filelist()));
}

KsoundrecordApp::~KsoundrecordApp()
{
	slot_saveMyOptions();
}

void KsoundrecordApp::initKeyAccel()
{
  keyAccel = new KAccel(this);
	
  // fileMenu accelerators
  keyAccel->connectItem(KAccel::New, this, SLOT(slotFileNew()));
  keyAccel->connectItem(KAccel::Open, this, SLOT(slotFileOpen()));
  keyAccel->connectItem(KAccel::Save, this, SLOT(slotFileSave()));
  keyAccel->connectItem(KAccel::Close, this, SLOT(slotFileClose()));
  keyAccel->connectItem(KAccel::Quit, this, SLOT(slotFileQuit()));
  // editMenu accelerators
  keyAccel->connectItem(KAccel::Cut, this, SLOT(slotEditCut()));
  keyAccel->connectItem(KAccel::Copy, this, SLOT(slotEditCopy()));
  keyAccel->connectItem(KAccel::Paste, this, SLOT(slotEditPaste()));

  keyAccel->connectItem(KAccel::Help, kapp, SLOT(appHelpActivated()));
			
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_NEW, KAccel::New);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_OPEN, KAccel::Open);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_SAVE, KAccel::Save);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_CLOSE, KAccel::Close);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_PRINT, KAccel::Print);
  keyAccel->changeMenuAccel(fileMenu, ID_FILE_QUIT, KAccel::Quit);

  keyAccel->changeMenuAccel(editMenu, ID_EDIT_CUT, KAccel::Cut);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_COPY, KAccel::Copy);
  keyAccel->changeMenuAccel(editMenu, ID_EDIT_PASTE, KAccel::Paste);

  keyAccel->readSettings();	
}

void KsoundrecordApp::initMenuBar()
{
  ///////////////////////////////////////////////////////////////////
  // MENUBAR


  ///////////////////////////////////////////////////////////////////
  // menuBar entry fileMenu
  fileMenu = new QPopupMenu();
  //fileMenu->insertItem(kapp->getMiniIcon(), i18n("New &Window"), ID_FILE_NEW_WINDOW);
  //fileMenu->insertSeparator();
  //fileMenu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW);
  fileMenu->insertItem(Icon("fileopen.xpm"), i18n("&Set Filemane..."), ID_FILE_OPEN);
  //fileMenu->insertItem(i18n("&Close"), ID_FILE_CLOSE);
  //fileMenu->insertSeparator();
  //fileMenu->insertItem(Icon("filefloppy.xpm") ,i18n("Save &mp3"), ID_FILE_SAVE);
  //fileMenu->insertItem(i18n("Save &wav..."), ID_FILE_SAVE_AS);
  fileMenu->insertSeparator();
  fileMenu->insertItem(i18n("E&xit"), ID_FILE_QUIT);
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry editMenu
  editMenu = new QPopupMenu();
  //editMenu->insertItem(Icon("editcut.xpm"), i18n("Cu&t"), ID_EDIT_CUT);
  //editMenu->insertItem(Icon("editcopy.xpm"), i18n("&Copy"), ID_EDIT_COPY);
  //editMenu->insertItem(Icon("editpaste.xpm"), i18n("&Paste"), ID_EDIT_PASTE);

	//////////////////////////////////////////////////////////////////
  // menuBar entry optionsMenu
  optionMenu = new QPopupMenu();
  optionMenu->insertItem(i18n("Mixer"), ID_MIXER);
  optionMenu->insertItem(i18n("Show &Console Output"), ID_OUTPUT);	
	optionMenu->insertSeparator();
	optionMenu->insertItem(i18n("&Ksoundrecord Options..."), ID_KSR_OPTIONS);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry viewMenu
  viewMenu = new QPopupMenu();
  viewMenu->setCheckable(true);
  viewMenu->insertItem(i18n("&Filelist"), ID_FILELIST);
  viewMenu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
  viewMenu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR);
  viewMenu->insertItem(i18n("Skin1"), ID_VIEW_BACKGROUND1);
  viewMenu->insertItem(i18n("Skin2"), ID_VIEW_BACKGROUND2);
  viewMenu->insertItem(i18n("Skin3"), ID_VIEW_BACKGROUND3);
  viewMenu->insertItem(i18n("Skin4"), ID_VIEW_BACKGROUND4);
  viewMenu->insertItem(i18n("Skin5"), ID_VIEW_BACKGROUND5);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry helpMenu
  QString aboutstring=(QString)"    KSoundrecord"+" "+VERSION+i18n("\n(c) 2000 Mathias Zander\n")+
  																		i18n(" General Public License\n\n")+i18n("   Design & Translation\n")+"   Thomas Wohlgemuth\n";
  														
  helpMenu = new QPopupMenu();
  helpMenu = kapp->getHelpMenu(true, aboutstring);

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), fileMenu);
  //menuBar()->insertItem(i18n("&Edit"), editMenu);
  menuBar()->insertItem(i18n("&View"), viewMenu);
	menuBar()->insertItem(i18n("&Options"), optionMenu);
  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), helpMenu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(fileMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(fileMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  //connect(editMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  //connect(editMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

  connect(optionMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(optionMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

	connect(viewMenu, SIGNAL(activated(int)), SLOT(commandCallback(int)));
  connect(viewMenu, SIGNAL(highlighted(int)), SLOT(statusCallback(int)));

}

void KsoundrecordApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  //toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New File"));
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Set filename"));
  toolBar()->insertButton(Icon("mix_ksr.xpm"), ID_MIXER, true, i18n("Show mixer"));
  toolBar()->insertButton(Icon("flist.xpm"), ID_FILELIST, true, i18n("Open filelist"));
  toolBar()->insertButton(Icon("opt.xpm"), ID_KSR_OPTIONS, true, i18n("Options"));
  toolBar()->setToggle(ID_FILELIST);
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("help_ksr.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked()),
  				kapp, SLOT(appHelpActivated()), true,i18n("Help"));

  ///////////////////////////////////////////////////////////////////
  // INSERT YOUR APPLICATION SPECIFIC TOOLBARS HERE WITH toolBar(n)


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
  // connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
  // connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void KsoundrecordApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n(IDS_STATUS_DEFAULT), ID_STATUS_MSG);
}

void KsoundrecordApp::initDocument()
{
  doc = new KsoundrecordDoc(this);
  doc->newDocument();
}

void KsoundrecordApp::initView()
{
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new KsoundrecordView(this);
  doc->addView(view);
  setView(view);
  QString caption="KSoundrecord";	
  setCaption(caption+": "+ rec_file.current()+".wav");
  view->zeit = -1;
  view->slotlcd();
}

void KsoundrecordApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, true);
  toolBar()->setItemEnabled(id_, true);
}

void KsoundrecordApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_, false);
  toolBar()->setItemEnabled(id_, false);
}

void KsoundrecordApp::openDocumentFile(const char* _cmdl)
{
slotStatusMsg(i18n("Opening file..."));

doc->openDocument(_cmdl);
slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}


KsoundrecordDoc *KsoundrecordApp::getDocument() const
{
  return doc;
}

void KsoundrecordApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int) menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos", (int) toolBar()->barPos());
  config->writeEntry("Filename", rec_file.first());
}


void KsoundrecordApp::readOptions()
{
	
  config->setGroup("General Options");

  rec_file.clear();
  hilfe = config->readEntry("Filename", "/tmp/ksoundrecord");
  rec_file.append(hilfe);
  wav_file.append(hilfe);
  bool * t = new bool(false);
  is_mp3.append(t);
  is_work.append(t);

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewMenu->setItemChecked(ID_VIEW_TOOLBAR, !bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewMenu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
  if(!bViewStatusbar)
  {
    enableStatusBar(KStatusBar::Hide);
  }

  // bar position settings
  KMenuBar::menuPosition menuBarPos;
  menuBarPos=(KMenuBar::menuPosition) config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);

  menuBar()->setMenuBarPos(menuBarPos);
  toolBar()->setBarPos(toolBarPos);
	
  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }


}

void KsoundrecordApp::saveProperties(KConfig *_cfg)
{
  if(doc->getTitle()!=i18n("Untitled") && !doc->isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    QString filename=doc->getAbsFilePath();	
    _cfg->writeEntry("filename",filename );
    _cfg->writeEntry("modified", doc->isModified());
		
    QString tempname = kapp->tempSaveName(filename);
    doc->saveDocument(tempname);
  }
}


void KsoundrecordApp::readProperties(KConfig* _cfg)
{
  QString filename = _cfg->readEntry("filename", "/D/ksoundrecord.wav");
  bool modified = _cfg->readBoolEntry("modified", false);
  if(modified)
  {
    bool canRecover;
    QString tempname = kapp->checkRecoverFile(filename, canRecover);
  	
    if(canRecover)
    {
      doc->openDocument(tempname);
      doc->setModified();
      QFileInfo info(filename);
      doc->setAbsFilePath(info.absFilePath());
      doc->setTitle(info.fileName());
      QFile::remove(tempname);
    }
  }
  else
  {
    if(!filename.isEmpty())
    {
      doc->openDocument(filename);
    }
  }
  setCaption("KSoundrecord: "+(QString)rec_file.current()+".wav");
}		

bool KsoundrecordApp::queryClose()
{
  return doc->saveModified();
}

bool KsoundrecordApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KsoundrecordApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));
	
  KsoundrecordApp *new_window= new KsoundrecordApp();
  new_window->show();

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));

  if(!doc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {	
    doc->newDocument();		

    QString caption=kapp->getCaption();	
    setCaption("KSoundrecord: "+(QString)rec_file.current()+".wav");
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotFileOpen()
{
  slotStatusMsg(i18n("Set Filename..."));
	
  {	
    QString neu_qs(KFileDialog::getSaveFileName(QDir::homeDirPath(),
        	      i18n("*.wav|*.wav"), this, i18n("Open File...")));
    int i,pos;
    pos = -1;
    rec_file.clear();
    do {
    		i = neu_qs.find(".wav",pos+1);
    		if(i!=-1)
    			pos = i;
     }while(i!=-1);
    do {
    		i = neu_qs.find(".WAV",pos+1);
    		if(i!=-1)
    			pos = i;
     }while(i!=-1); 	
    if(pos!=-1)
    	neu_qs.remove(pos,4);	
    {
      rec_file.append(neu_qs);
      setCaption((QString)"KSoundrecord: "+rec_file.current()+".wav");
    }
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotFileSave()
{

  slotStatusMsg(i18n("Saving tempfile"));
//Del by KDevelop:
//Del by KDevelop:  QString newName=KFileDialog::getSaveFileName(QDir::homeDirPath(),
//Del by KDevelop:                                               i18n("*.wav|*.wav"), this, i18n("Save wavfile"));
//Del by KDevelop:  if(!newName.isEmpty())
//Del by KDevelop:  {
//Del by KDevelop:    QFileInfo saveAsInfo(newName);
//Del by KDevelop:    doc->setTitle(saveAsInfo.fileName());
//Del by KDevelop:    doc->setAbsFilePath(saveAsInfo.absFilePath());
//Del by KDevelop:    doc->saveDocument(newName);
//Del by KDevelop:    addRecentFile(newName);
//Del by KDevelop:
//Del by KDevelop:
//Del by KDevelop:    setCaption("KSoundrecord: "+rec_file.current()+".wav");
//Del by KDevelop:  }
//Del by KDevelop:
//Del by KDevelop:  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
//Del by KDevelop:
/*  statusMsg(i18n("Saving file..."));
	
  doc->saveDocument(doc->getAbsFilePath());

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT)); */
}

void KsoundrecordApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving tempfile"));

  QString newName=KFileDialog::getSaveFileName(QDir::homeDirPath(),
                                               i18n("*.wav|*.wav"), this, i18n("Save wavfile"));
  if(!newName.isEmpty())
  {
    QFileInfo saveAsInfo(newName);
    doc->setTitle(saveAsInfo.fileName());
    doc->setAbsFilePath(saveAsInfo.absFilePath());
    doc->saveDocument(newName);

    QString caption=kapp->getCaption();	
    setCaption("KSoundrecord: "+(QString)rec_file.current()+".wav");
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));
	
  close();
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  slotStop();
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KTMainWindow* w;
  if(memberList)
  {
	  for(w=memberList->first(); w!=0; w=memberList->first())
  {
   // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
   // the window and the application stay open.
    if(!w->close())
	break;
   }
  }	
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggle the toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_TOOLBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, false);
    enableToolBar(KToolBar::Hide);
    this->setFixedSize(302,173);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_TOOLBAR, true);
    enableToolBar(KToolBar::Show);
    this->setFixedSize(302,200);
  }		

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}

void KsoundrecordApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if( viewMenu->isItemChecked(ID_VIEW_STATUSBAR))
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, false);
    enableStatusBar(KStatusBar::Hide);
  }
  else
  {
    viewMenu->setItemChecked(ID_VIEW_STATUSBAR, true);
    enableStatusBar(KStatusBar::Show);
  }

  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}


void KsoundrecordApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}


void KsoundrecordApp::slotStatusHelpMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 2000);
}



void KsoundrecordApp::commandCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotFileNewWindow();
    	 break;

    case ID_FILE_NEW:
    	 slotFileNew();
         break;

    case ID_FILE_OPEN:
         slotFileOpen();
         break;

    case ID_FILE_SAVE:
         slotFileSave();
         break;

    case ID_FILE_SAVE_AS:
         slotFileSaveAs();
         break;

    case ID_FILE_CLOSE:
         slotFileClose();
         break;

    case ID_FILE_QUIT:
         slotFileQuit();
         break;

    case ID_EDIT_CUT:
         slotEditCut();
         break;

    case ID_EDIT_COPY:
         slotEditCopy();
         break;

    case ID_EDIT_PASTE:
         slotEditPaste();
         break;

    case ID_VIEW_TOOLBAR:
         slotViewToolBar();
         break;

    case ID_VIEW_STATUSBAR:
         slotViewStatusBar();
         break;

    case ID_VIEW_BACKGROUND1:
         slot_background1();
         break;

    case ID_VIEW_BACKGROUND2:
         slot_background2();
         break;

    case ID_VIEW_BACKGROUND3:
         slot_background3();
         break;

    case ID_VIEW_BACKGROUND4:
         slot_background4();
         break;

    case ID_VIEW_BACKGROUND5:
         slot_background5();
         break;

		case ID_OUTPUT:
   			 slotViewOutput();
				 break;		

		case ID_KSR_OPTIONS:
         slotOptions();
         break;	

    case ID_FILELIST:
         slot_view_filelist(wav_file);
         break;

    case ID_MIXER:
         slotMixer();
         break;

    default:
         break;
  }
}

void KsoundrecordApp::statusCallback(int id_)
{
  switch (id_)
  {
    case ID_FILE_NEW_WINDOW:
         slotStatusHelpMsg(i18n("Opens a new application window"));
         break;

    case ID_FILE_NEW:
         slotStatusHelpMsg(i18n("Creates a new document"));
         break;

    case ID_FILE_OPEN:
         slotStatusHelpMsg(i18n("Set the Name and Path of File to record"));
         break;

    case ID_FILE_OPEN_RECENT:
         slotStatusHelpMsg(i18n("Opens a recently used file"));
         break;

    case ID_FILE_SAVE:
         slotStatusHelpMsg(i18n("Saves the actual document"));
         break;

    case ID_FILE_SAVE_AS:
         slotStatusHelpMsg(i18n("Saves the actual document as..."));
         break;

    case ID_FILE_CLOSE:
         slotStatusHelpMsg(i18n("Closes the actual document"));
         break;

    case ID_FILELIST:
         slotStatusHelpMsg(i18n("Use filelist"));
         break;

    case ID_FILE_QUIT:
         slotStatusHelpMsg(i18n("Quits the application"));
         break;

    case ID_EDIT_CUT:
         slotStatusHelpMsg(i18n("Cuts the selected section and puts it to the clipboard"));
         break;

    case ID_EDIT_COPY:
         slotStatusHelpMsg(i18n("Copies the selected section to the clipboard"));
         break;

    case ID_EDIT_PASTE:
         slotStatusHelpMsg(i18n("Pastes the clipboard contents to actual position"));
         break;

    case ID_VIEW_TOOLBAR:
         slotStatusHelpMsg(i18n("Enables/disables the toolbar"));
         break;

    case ID_VIEW_STATUSBAR:
         slotStatusHelpMsg(i18n("Enables/disables the statusbar"));
         break;


   case ID_OUTPUT:
        slotStatusHelpMsg(i18n("Show Console Log"));
        break;

   case ID_MIXER:
        slotStatusHelpMsg(i18n("Start mixer"));
        break;

    default:
         break;
  }
}
/** record the file with use of program rec */
void KsoundrecordApp::slotRec(){
	if(!view->file_list->isVisible())
  {	
  	viewMenu->setItemChecked(ID_FILELIST, false);
  	toolBar()->setButton(ID_FILELIST,false);
	}
	int rec_index=0;
	view->zeit = 0;
	slot_prog_args();
	recProc->clearArguments ();
	int i=0;
		do
		{
			(*recProc) << rec_args[i++];
		}while(rec_args[i]);
	QFileInfo fi(((QString)rec_file.current())+".wav");
	QString rec_nr;
	int answer=-1;
	if(ask==1)
	{
		QString hilfe(rec_file.current());
		answer = QMessageBox::warning(0,i18n("KSoundrecord - File exists"),
				"The File "+((QString)wav_file.current())+".wav exists.\nCreate new file?", i18n("Yes"), i18n("No"),
				i18n("Cancel"),0,2); 	
	}					 	
	if(answer!=2)
		{
		if(ask==2 | answer==1)	
		{
			(*recProc) << (QString)rec_file.first()+".wav";
		  wav_nr = 0;
		}
		if(ask==3 | answer==0)
		{
			if(fi.exists())
							{	
								rec_index = rec_file.at();
								do
								{
									rec_index += 1;
									if(rec_index<10)
										hilfe.setStr((QString)rec_file.first()+"_0"+rec_nr.setNum(rec_index));
									else
										hilfe.setStr((QString)rec_file.first()+"_"+rec_nr.setNum(rec_index));
									rec_file.append(hilfe);
									fi.setFile((QString)rec_file.at(rec_index)+".wav");
							 	}while(fi.exists());
							wav_file.append(rec_file.current());
							bool * t = new bool(false);
							is_mp3.append(t);
							is_work.append(t);
							setCaption((QString)"KSoundrecord: "+rec_file.current()+".wav");
							}	
		(*recProc) << (QString)rec_file.current()+".wav";
	}
	recProc->start(KProcess::NotifyOnExit,KProcess::Stdout);
	view->timer->start(1000);
	statusBar()->changeItem(i18n("Record"),ID_STATUS_MSG);
	}	
}
/** stop */
void KsoundrecordApp::slotStop(){
	wav_file.last();
	mp3Proc->kill();
	mp3playProc->kill();
	if(record_prog==2)
	{
		QString qs;
		int pid;
		pid = (recProc->getPid ());
		if(pid!=0)
		{
			qs.setNum(pid);
			findsoxProc->clearArguments();	
			(*findsoxProc) << "pstree" << "-p" << qs;
			findsoxProc->start(KProcess::NotifyOnExit,KProcess::Stdout);
		}	
	}
	else
	{
		recProc->kill();
		playProc->kill();
	}
	view->timer->stop();
	statusBar()->changeItem(i18n("Ready"),ID_STATUS_MSG);
}
/** play wav-file */
void KsoundrecordApp::slotPlay(){
	if(!view->file_list->isVisible())
  {	
  	viewMenu->setItemChecked(ID_FILELIST, false);
  	toolBar()->setButton(ID_FILELIST,false);
	}
	if(viewMenu->isItemChecked(ID_FILELIST))
	{
		hilfe = (view->file_list->next_selected(wav_file,true,true));
		if(!hilfe)
		{
		 	hilfe = rec_file.current();
			hilfe = hilfe+".wav";
		}
			
	}
	else
	{	
		hilfe = rec_file.current();
		hilfe = hilfe+".wav";
	}
	view->zeit = 0;
	if(hilfe)
	{
		playProc->clearArguments();
		if(record_prog==2)
			(*playProc) << "play"	<< hilfe;
		if(record_prog==1)
			(*playProc) << "playsample"	<< hilfe;
		playProc->start(KProcess::NotifyOnExit,KProcess::Stdout);
		view->timer->start(1000);
	  statusBar()->changeItem(i18n("Play"),ID_STATUS_MSG);
	}
}
/** show recordtime  */
void KsoundrecordApp::slot_length_label(KProcess* kproc, char* buffer, int i){
	int index=3;
	char s[8];
	buffer[i]=0;
	view->output_window->QMultiLineEdit_1->append(buffer);	
	if (kproc==mp3Proc)
	{
		do
		{
			if(buffer[index]=='(')
			{
				if(buffer[index+4]=='%')
				{
					s[0]=(buffer[index+1]);
					s[1]=(buffer[index+2]);
					s[2]=(buffer[index+3]);
					s[3]=':';
					s[4]='1';
					s[5]='0';
					s[6]='0';
					s[7]=0;
					view->timelcd->display(s);
				}
			}
		}while(index++<i);
	}			
}
/** encode temp file to mp3 */
void KsoundrecordApp::slotEncode(){
		if(!view->file_list->isVisible())
  {	
  	viewMenu->setItemChecked(ID_FILELIST, false);
  	toolBar()->setButton(ID_FILELIST,false);
	}
		static bool fl=false;
		if(!fl && viewMenu->isItemChecked(ID_FILELIST))
		{
			wav_file.first();
			fl = true;
		}
		if(fl)
		{
			if(!wav_file.next())
			{	
				fl=false;
				wav_file.last();
			}
			else
				wav_file.prev();
		}
		slot_prog_args();
		mp3Proc->clearArguments();
		int i=0;
		do	{
			(*mp3Proc) << mp3_args[i++];
		}while(mp3_args[i]);
		hilfe = wav_file.current();
		hilfe += ".wav";
		(*mp3Proc) << hilfe;
		hilfe = wav_file.current();
		hilfe += ".mp3";
		(*mp3Proc) << hilfe;
	  mp3Proc->start(KProcess::NotifyOnExit,KProcess::Stderr);
		is_work.remove(wav_file.at());
		bool * t = new bool(true);
		is_work.insert(wav_file.at(),t);
		view->file_list->slot_show_list(wav_file,is_mp3,is_work);
		statusBar()->changeItem(i18n("Encode"),ID_STATUS_MSG);
}
/**  */
void KsoundrecordApp::slotViewOutput(){
	
	if( optionMenu->isItemChecked(ID_OUTPUT))
  	{
    	optionMenu->setItemChecked(ID_OUTPUT, false);
    	view->slotstdout(false);
  	}
  	else
  	{
    	optionMenu->setItemChecked(ID_OUTPUT, true);
    	view->slotstdout(true);
  	}		
}/** start Mixer */
void KsoundrecordApp::slotMixer(){
	(*mixProc) << "kmix";
	mixProc->start(KProcess::NotifyOnExit,KProcess::Stderr);
}
/** record exit */
void KsoundrecordApp::slotrecstop(){
	view->timer->stop();
	view->file_list->slot_show_list(wav_file,is_mp3,is_work);
	statusBar()->changeItem(i18n("Recod finished"),ID_STATUS_MSG);
}
/** Play exit */
void KsoundrecordApp::slotplaystop(){
	view->timer->stop();
	view->file_list->slot_show_list(wav_file,is_mp3,is_work);
	if(viewMenu->isItemChecked(ID_FILELIST) && view->file_list->next_selected(wav_file,false,false))
		slotPlay();
	else	
		statusBar()->changeItem(i18n("Play finished"),ID_STATUS_MSG);
}
/** encode exit */
void KsoundrecordApp::slotmp3stop(){
	is_mp3.remove(wav_file.at());
	bool * t = new bool(true);
	is_mp3.insert(wav_file.at(),t);
	view->file_list->slot_show_list(wav_file,is_mp3,is_work);
	if(viewMenu->isItemChecked(ID_FILELIST) && wav_file.next())
		slotEncode();
	else
		statusBar()->changeItem(i18n("Encode finished"),ID_STATUS_MSG);
}
/** Options Dialog */
void KsoundrecordApp::slotOptions(){
	view->options_dialog->show();
}
/** record,mp3 ... Options */

void KsoundrecordApp::slot_readMyOptions(){
	int id_mode = 2;
	config->setGroup("MP3 Options");
  view->options_dialog->fast->setChecked(config->readBoolEntry("Fast", false));
  view->options_dialog->voice->setChecked(config->readBoolEntry("Voice", false));
  view->options_dialog->quality->setChecked(config->readBoolEntry("Quality", false));
  view->options_dialog->checksum->setChecked(config->readBoolEntry("Checksum", false));
  view->options_dialog->copyright->setChecked(config->readBoolEntry("Copyright", false));
  view->options_dialog->non_original->setChecked(config->readBoolEntry("Non_Original", false));
  view->options_dialog->graphical->setChecked(config->readBoolEntry("Graphical", false));

  stereo.setStr(config->readEntry("Strereo_Mode", "j"));
  if(stereo=="s")	id_mode = 1;
  if(stereo=="j")	id_mode = 2;
  if(stereo=="f")	id_mode = 3;
  if(stereo=="m")	id_mode = 4;
	view->options_dialog->mp3_mode->setButton(id_mode);
  bitrate.setStr(config->readEntry("Bitrate", "128"));
	int x=-1;	
	if(bitrate.toInt()==8)		x=1;
	if(bitrate.toInt()==16)   x=2;
	if(bitrate.toInt()==24)   x=3;
	if(bitrate.toInt()==32)   x=4;
	if(bitrate.toInt()==40)   x=5;
	if(bitrate.toInt()==48)   x=6;
	if(bitrate.toInt()==56)   x=7;
	if(bitrate.toInt()==64)   x=8;
	if(bitrate.toInt()==80)   x=9;
	if(bitrate.toInt()==96)   x=10;
	if(bitrate.toInt()==112)  x=11;
	if(bitrate.toInt()==128)  x=12;
	if(bitrate.toInt()==144)  x=13;
	if(bitrate.toInt()==160)  x=14;
	if(bitrate.toInt()==192)  x=15;
	if(bitrate.toInt()==224)  x=16;
	if(bitrate.toInt()==256)  x=17;
	if(bitrate.toInt()==320)  x=18;
	slot_bitrate_changed(x);
	view->options_dialog->bitrate_slider->setValue(x);
	view->slot_enable_vbr(config->readBoolEntry("VBR", false));
	vbr_rate.setStr(config->readEntry("VBR_RATE", "4"));
	view->options_dialog->vbr_slider->setValue(vbr_rate.toInt());
  slot_vbr_changed(vbr_rate.toInt());
	
	config->setGroup("Record Options");
	record_prog = config->readNumEntry("Record_Program", 1);	
	view->options_dialog->group_prog->setButton(record_prog);
	slot_prog(record_prog);
	rec_samplerate = config->readNumEntry("Samplerate", 44);	
	view->options_dialog->group_samplerate->setButton(rec_samplerate);
	rec_bits = config->readNumEntry("Bits", 16);	
	view->options_dialog->group_bit->setButton(rec_bits);
	rec_channels = config->readNumEntry("Channels", 2);	
	view->options_dialog->group_stereo->setButton(rec_channels);	
	ask = config->readNumEntry("Ask", 3);	
	view->options_dialog->group_ask->setButton(ask);		
	
	config->setGroup("View Options");
	background = config->readNumEntry("Background", 1);
	if(background==1) slot_background1();
	if(background==2) slot_background2();
	if(background==3) slot_background3();
	if(background==4) slot_background4();
	if(background==5) slot_background5();
	
	QString caption="KSoundrecord";	
  setCaption("KSoundrecord: "+(QString)rec_file.current()+".wav");
  slot_prog_args();
}	

void KsoundrecordApp::slot_saveMyOptions(){
	config->setGroup("MP3 Options");
	config->writeEntry("Strereo_Mode", stereo);
	config->writeEntry("Bitrate", bitrate);
	config->writeEntry("VBR", view->options_dialog->vbr->isChecked());
	config->writeEntry("VBR_RATE", vbr_rate);
	config->writeEntry("Fast", view->options_dialog->fast->isChecked());
	config->writeEntry("Voice", view->options_dialog->voice->isChecked());
	config->writeEntry("Quality", view->options_dialog->quality->isChecked());
	config->writeEntry("Checksum", view->options_dialog->checksum->isChecked());
	config->writeEntry("Copyright", view->options_dialog->copyright->isChecked());
	config->writeEntry("Non_Original", view->options_dialog->non_original->isChecked());
	config->writeEntry("Graphical", view->options_dialog->graphical->isChecked());
			
	config->setGroup("Record Options");
	config->writeEntry("Record_Program", record_prog);
	config->writeEntry("Samplerate", rec_samplerate);
	config->writeEntry("Bits", rec_bits);
	config->writeEntry("Channels", rec_channels);
	config->writeEntry("Ask", ask);
	
	config->setGroup("View Options");
	config->writeEntry("Background", background);
	                                                  	
	slot_prog_args();
}

/**  */
void KsoundrecordApp::slot_stereo(int mode){

switch(mode)
	{
	 	case 1:	stereo.setStr("s");
	 					break;
	 	case 2:	stereo.setStr("j");
	 					break;
	 	case 3:	stereo.setStr("f");
	 					break;
	 	case 4:	stereo.setStr("m");
	 					break;				
	}
}/**  */
void KsoundrecordApp::slot_prog(int prog){
	record_prog	= prog;
	if(prog==1)
		view->options_dialog->rate_24->setEnabled(false);
	else
		view->options_dialog->rate_24->setEnabled(true);
}
/**  */
void KsoundrecordApp::slot_prog_args(){
	/** set the arguments for encoding */
  int j=0;
  mp3_args[j++].setStr("lame");
  if(view->options_dialog->fast->isChecked())
  	mp3_args[j++].setStr("-f");
  mp3_args[j++].setStr("-m");
	mp3_args[j++].setStr(stereo);
	if(view->options_dialog->voice->isChecked())
		mp3_args[j++].setStr("--voice");
  if(view->options_dialog->quality->isChecked())
  	mp3_args[j++].setStr("-h");
  if(view->options_dialog->checksum->isChecked())
  	mp3_args[j++].setStr("-p");
  if(view->options_dialog->copyright->isChecked())
  	mp3_args[j++].setStr("-c");
  if(view->options_dialog->non_original->isChecked())
  	mp3_args[j++].setStr("-o");
  if(view->options_dialog->graphical->isChecked())
  	mp3_args[j++].setStr("-g");
	
	if(view->options_dialog->vbr->isChecked())
	{
		mp3_args[j++].setStr("-v");
		mp3_args[j++].setStr("-V");
		mp3_args[j++].setStr(vbr_rate);
	}
	else
	{
		mp3_args[j++].setStr("-b");
		mp3_args[j++].setStr(bitrate);
	}	
		mp3_args[j] = NULL;
	/** set the arguments for recording */
	if(record_prog==2)
	{
		int i = 0;
		rec_args[i++].setStr("rec");
  	rec_args[i++].setStr("-r");
		switch(rec_samplerate)
		{
			case 16: 	rec_args[i++].setStr("16000");
								break;
			case 22: 	rec_args[i++].setStr("22050");
								break;
			case 24: 	rec_args[i++].setStr("24000");
								break;
			case 32: 	rec_args[i++].setStr("32000");
								break;
			case 44: 	rec_args[i++].setStr("44100");
								break;
			case 48: 	rec_args[i++].setStr("48000");
								break;
		}	
		rec_args[i++].setStr("-c");
		if(rec_channels==1)
			rec_args[i++].setStr("1");
		if(rec_channels==2)
			rec_args[i++].setStr("2");
		if(rec_bits==8)
			rec_args[i++].setStr("-b");
		if(rec_bits==16)
			rec_args[i++].setStr("-w");
		rec_args[i] = NULL;	
  }
	if(record_prog==1)
	{
		int i = 0;
		rec_args[i++].setStr("soundrecorder");
  	rec_args[i++].setStr("-k");
		rec_args[i++].setStr("-c");
		if(rec_channels==1)
			rec_args[i++].setStr("1");
		if(rec_channels==2)
			rec_args[i++].setStr("2");
		rec_args[i++].setStr("-b");
		if(rec_bits==8)
			rec_args[i++].setStr("8");
		if(rec_bits==16)
			rec_args[i++].setStr("16");
		rec_args[i++].setStr("-s");
		switch(rec_samplerate)
		{
			case 16: 	rec_args[i++].setStr("16000");
								break;
			case 22: 	rec_args[i++].setStr("22050");
								break;
			case 24: 	rec_args[i++].setStr("24000");
								break;
			case 32: 	rec_args[i++].setStr("32000");
								break;
			case 44: 	rec_args[i++].setStr("44100");
								break;
			case 48: 	rec_args[i++].setStr("48000");
								break;
		}			
	rec_args[i] = NULL;			
	}	
}
/**  */
void KsoundrecordApp::slot_rec_stereo(int i){
	rec_channels	= i;
}
/**  */
void KsoundrecordApp::slot_rec_bits(int i){
	rec_bits = i;
}
/**  */
void KsoundrecordApp::slot_rec_samplerate(int i){
  rec_samplerate = i;
}
/**  */
void KsoundrecordApp::slot_mp3_play(){
	unsigned int i;
	mp3playProc->clearArguments();
	(*mp3playProc) << "xmms";
	for(i=0;i<wav_file.count();i++)
	{
		if(*is_mp3.at(i))
		(*mp3playProc) << (QString)wav_file.at(i)+".mp3";
	}
	mp3playProc->start(KProcess::NotifyOnExit,KProcess::Stderr);
	statusBar()->changeItem("Play mp3",ID_STATUS_MSG);
}
/**  */
void KsoundrecordApp::slot_bitrate_changed(int value){
	switch(value)
	{	
	 	case 1: bitrate.setNum(8); break;
	 	case 2: bitrate.setNum(16); break;
	 	case 3: bitrate.setNum(24); break;
	 	case 4: bitrate.setNum(32); break;
	 	case 5: bitrate.setNum(40); break;
	 	case 6: bitrate.setNum(48); break;
	 	case 7: bitrate.setNum(56); break;
	 	case 8: bitrate.setNum(64); break;
	 	case 9: bitrate.setNum(80); break;
	 	case 10: bitrate.setNum(96); break;
	 	case 11: bitrate.setNum(112); break;
	 	case 12: bitrate.setNum(128); break;
	 	case 13: bitrate.setNum(144); break;
	 	case 14: bitrate.setNum(160); break;
	 	case 15: bitrate.setNum(192); break;
	 	case 16: bitrate.setNum(224); break;
	 	case 17: bitrate.setNum(256); break;
	 	case 18: bitrate.setNum(320); break;
	}
	view->options_dialog->lcd_bitrate->display(bitrate);
	view->options_dialog->label_bitrate_freq3->setEnabled(true);
	view->options_dialog->label_bitrate_freq1->setEnabled(true);
	view->options_dialog->label_bitrate_freq2->setEnabled(true);
	view-> slot_show_freq(value);
}
/**  */
void KsoundrecordApp::slot_background1(){
	slot_no_background();
	view->setBackgroundPixmap(QPixmap(kapp->kde_datadir()+"/ksoundrecord/pics/skin1.gif"));
	//view->timelcd->setSegmentStyle(QLCDNumber::Outline);//Filled OutlineFlat
	background = 1;
	viewMenu->setItemChecked(ID_VIEW_BACKGROUND1, true);
}
void KsoundrecordApp::slot_background2(){
	slot_no_background();
	view->setBackgroundPixmap(QPixmap(kapp->kde_datadir()+"/ksoundrecord/pics/skin2.gif"));
	//view->timelcd->setSegmentStyle(QLCDNumber::Filled);//Filled OutlineFlat
	background = 2;
	viewMenu->setItemChecked(ID_VIEW_BACKGROUND2, true);
}
void KsoundrecordApp::slot_background3(){
	slot_no_background();
	view->setBackgroundPixmap(QPixmap(kapp->kde_datadir()+"/ksoundrecord/pics/skin3.gif"));
  //view->timelcd->setSegmentStyle(QLCDNumber::Flat);//Filled OutlineFlat
  background = 3;
  viewMenu->setItemChecked(ID_VIEW_BACKGROUND3, true);
}
void KsoundrecordApp::slot_background4(){
	slot_no_background();
	view->setBackgroundPixmap(QPixmap(kapp->kde_datadir()+"/ksoundrecord/pics/skin4.gif"));
  //view->timelcd->setSegmentStyle(QLCDNumber::Filled);//Filled OutlineFlat
  background = 4;
  viewMenu->setItemChecked(ID_VIEW_BACKGROUND4, true);
}
void KsoundrecordApp::slot_background5(){
	slot_no_background();
	view->setBackgroundPixmap(QPixmap(kapp->kde_datadir()+"/ksoundrecord/pics/skin5.gif"));
  //view->timelcd->setSegmentStyle(QLCDNumber::Filled);//Filled OutlineFlat
  background = 5;
  viewMenu->setItemChecked(ID_VIEW_BACKGROUND5, true);
}/**  */
void KsoundrecordApp::slot_no_background(){
	viewMenu->setItemChecked(ID_VIEW_BACKGROUND1, false);	
	viewMenu->setItemChecked(ID_VIEW_BACKGROUND2, false);
	viewMenu->setItemChecked(ID_VIEW_BACKGROUND3, false);
	viewMenu->setItemChecked(ID_VIEW_BACKGROUND4, false);
	viewMenu->setItemChecked(ID_VIEW_BACKGROUND5, false);
}
/**  */
void KsoundrecordApp::slot_ask_opt(int i){
	ask = i;	
}
/**  */
void KsoundrecordApp::slot_vbr_changed(int value){
 	vbr_rate.setNum(value);
	view->options_dialog->lcd_vbr->display(vbr_rate);
	slot_prog_args();
}
/**  */
void KsoundrecordApp::slot_kill_sox(KProcess* kproc, char* buffer, int i){
	int start,end;
	QString qs(buffer);
	killSoxProc->clearArguments();
	start = qs.find("sox(");
	if(start!=-1)
	{
		start = start + 4;
		end = qs.find(")",start);
		qs = qs.mid(start,end-start);
		(*killSoxProc) << "kill" << "-2" << qs;
		killSoxProc->start();
	}
}
void KsoundrecordApp::slot_view_filelist(QStrList filelist){
	slotStatusMsg(i18n("Show filelist..."));
  if(viewMenu->isItemChecked(ID_FILELIST))
  {
    viewMenu->setItemChecked(ID_FILELIST, false);
    view->file_list->hide();
    toolBar()->setButton(ID_FILELIST,false);
  }
  else
  {
    viewMenu->setItemChecked(ID_FILELIST, true);
    view->file_list->slot_show_list(filelist,is_mp3,is_work);
    view->file_list->show();
    toolBar()->setButton(ID_FILELIST,true);
  }	
	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
}
void KsoundrecordApp::slot_hide_filelist(){
	slotStatusMsg(i18n("Hide filelist..."));
  view->file_list->hide();
  viewMenu->setItemChecked(ID_FILELIST, false);
 	slotStatusMsg(i18n(IDS_STATUS_DEFAULT));
 	toolBar()->setButton(ID_FILELIST,false);
}
/** add filenames to filelist */
void KsoundrecordApp::slot_add_filesnames(){
	slotStatusMsg(i18n("Add filenames to filelist..."));
	
  	QStrList neu_qslist;
    QString neu_qs;
    QFileDialog* qfd = new QFileDialog();
    neu_qslist = qfd->getOpenFileNames("*.wav", QDir::homeDirPath(),this, i18n("Open File..."));

		neu_qs = neu_qslist.first();
    while(neu_qs) {
			int i,pos;
    	pos = 0;
    	do {
    		i = neu_qs.find(".wav",pos+1);
    		if(i!=-1)
    			pos = i;
     	}while(i!=-1);
    	do {
    		i = neu_qs.find(".WAV",pos+1);
    		if(i!=-1)
    			pos = i;
     	}while(i!=-1); 	
    	if(pos!=-1)
    		neu_qs.remove(pos,4);	
    	wav_file.append(neu_qs);
  		bool * t = new bool(false);
			is_mp3.append(t);
			is_work.append(t);
  		neu_qs = neu_qslist.next();
  	}
  delete(qfd);
  view->file_list->slot_show_list(wav_file,is_mp3,is_work);
  slotStatusMsg(i18n(IDS_STATUS_DEFAULT));	
}
/** remove files from filelist */
void KsoundrecordApp::slot_remove_files(){
	QString qs(view->file_list->next_selected(wav_file,true,false));
	while(qs) {
		int i;
		i = qs.find(".wav");
		qs.remove(i,4);
		i = wav_file.find(qs);
		is_mp3.remove(i);
		is_work.remove(i);
		wav_file.remove(qs);
		qs = view->file_list->next_selected(wav_file,true,false);
	}
	view->file_list->slot_show_list(wav_file,is_mp3,is_work);
}
