//
// /home/ms/sidplay/qtsidplay/RCS/MixerDialog.cpp,v
//
// This file is a mess. Instead of a normal toggle-button a more flexible
// one should have been used.


#include "GlobalExt.h"
#include "MixerDialog.h"

#include <kapp.h>

#define Inherited MixerDialogData


// These always reflect the volume slider position.
// Slider values: 0=top, 100=bottom
uword voiceMasterVol[4] =
{
	256, 256, 256, 256
};

// Mute masks: 0 = off, 65535 = on
static uword voiceMute[4] =
{
	65535, 65535, 65535, 65535
};

struct voiceVol
{
	uword l, r;  // left/right pan level
};

voiceVol voiceHQvol[4] =
{
	{ 255,0 }, { 0,255 }, { 255,0 }, { 0,255 }
};
	
voiceVol voiceFPvol[4] =
{
	{ 255,0 }, { 0,255 }, { 255,0 }, { 0,255 }
};

// This is used to read out the default volume after mixing mode has been
// changed and we later only want to change the voice master volume.
// Setting other L/R levels together with the voice master volume will
// affect the auto-panning boundaries.
voiceVol voiceInternalVol[4];

void readDefaultVoiceVolume()
{
	for (int v = 1; v <= 4; v++)
	{
		uword readLR = myEmuEngine.getVoiceVolume(v);
		voiceInternalVol[v-1].r = readLR & 255;
		voiceInternalVol[v-1].l = readLR >> 8;
	}
}

// --------------------------------------------------------------------------

MixerDialog::MixerDialog
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
	setCaption( i18n("Software Mixer") );
	setFixedSize(width(),height());
	setIcon(*myMainIcon);

	mixerOffBtn->setText( i18n("Off") );
	mixerOffBtn->setAutoRepeat( FALSE );
	connect( mixerOffBtn, SIGNAL(clicked()), SLOT(setMixerOff()) );
	mixerGrp->insert(mixerOffBtn);

	highQualityBtn->setColour(LEDButton::green);
	highQualityBtn->setText( i18n("High quality") );
	highQualityBtn->setAutoRepeat( FALSE );
	connect( highQualityBtn, SIGNAL(clicked()), SLOT(setHighQuality()) );
	mixerGrp->insert(highQualityBtn);
	
	fullPanningBtn->setColour(LEDButton::green);
	fullPanningBtn->setText( i18n("Full panning") );
	fullPanningBtn->setAutoRepeat( FALSE );
	connect( fullPanningBtn, SIGNAL(clicked()), SLOT(setFullPanning()) );
	mixerGrp->insert(fullPanningBtn);
	
	effectsOffBtn->setText( i18n("None") );
	effectsOffBtn->setAutoRepeat( FALSE );
	connect( effectsOffBtn, SIGNAL(clicked()), SLOT(setEffectsOff()) );
	effectsGrp->insert(effectsOffBtn);
	
	surroundBtn->setColour(LEDButton::green);
	surroundBtn->setText( i18n("Surround") );
	surroundBtn->setAutoRepeat( FALSE );
	connect( surroundBtn, SIGNAL(clicked()), SLOT(setStereoSurround()) );
	effectsGrp->insert(surroundBtn);
	
	centeredPanningBtn->setColour(LEDButton::green);
	centeredPanningBtn->setText( i18n("Centered AP") );
	centeredPanningBtn->setAutoRepeat( FALSE );
	connect( centeredPanningBtn, SIGNAL(clicked()), SLOT(setCenteredPanning()) );
	effectsGrp->insert(centeredPanningBtn);
	
	volSliders[0] = voice1volSld;
	volSliders[1] = voice2volSld;
	volSliders[2] = voice3volSld;
	volSliders[3] = voice4volSld;

	panSliders[0] = voice1panSld;
	panSliders[1] = voice2panSld;
	panSliders[2] = voice3panSld;
	panSliders[3] = voice4panSld;

	muteButtons[0] = voice1muteBtn;
	muteButtons[1] = voice2muteBtn;
	muteButtons[2] = voice3muteBtn;
	muteButtons[3] = voice4muteBtn;

	soloButtons[0] = voice1soloBtn;
	soloButtons[1] = voice2soloBtn;
	soloButtons[2] = voice3soloBtn;
	soloButtons[3] = voice4soloBtn;

	effectWidgets[0] = effectsGrp;
	effectWidgets[1] = effectsOffBtn;
	effectWidgets[2] = surroundBtn;
	effectWidgets[3] = centeredPanningBtn;

	dontTouchMuteButtons = false;
	soloIsX = (-1);
	
	presetButtons();
}

MixerDialog::~MixerDialog()
{
}

void MixerDialog::checkMixerButtons(bool off, bool hq, bool fp)
{
	mixerOffBtn->setChecked(off);
	highQualityBtn->setChecked(hq);
	fullPanningBtn->setChecked(fp);
}

void MixerDialog::setMixerOff()
{
	if ( !mixerOffBtn->isChecked() )
	{
		checkMixerButtons(true,false,false);
		// Switch off stereo effects.
		checkEffectButtons(false,false,false);
		myEmuConfig.volumeControl = SIDEMU_NONE;
		myEmuConfig.autoPanning = SIDEMU_NONE;
		myEmuEngine.setConfig(myEmuConfig);
		allMuteSoloButtonsOff();
		adjustMixerMode();
	}
}

void MixerDialog::setHighQuality()
{
	if ( !highQualityBtn->isChecked() )
	{
		checkMixerButtons(false,true,false);
		// Switch off stereo effects.
		checkEffectButtons(false,false,false);
		myEmuConfig.volumeControl = SIDEMU_VOLCONTROL;
		myEmuConfig.autoPanning = SIDEMU_NONE;
		myEmuEngine.setConfig(myEmuConfig);
		// Write custom volume levels.
		restoreAllVoices();
		adjustPanningSliders();
		adjustMixerMode();
	}
}

void MixerDialog::setFullPanning()
{
	if ( !fullPanningBtn->isChecked() )
	{
		checkMixerButtons(false,false,true);
		checkEffectButtons(true,false,false);
		myEmuConfig.volumeControl = SIDEMU_FULLPANNING;
		myEmuConfig.autoPanning = SIDEMU_NONE;
		myEmuEngine.setConfig(myEmuConfig);
		// Write custom volume levels.
		restoreAllVoices();
		adjustPanningSliders();
		adjustMixerMode();
	}
}

void MixerDialog::checkEffectButtons(bool off, bool ss, bool cap)
{
	centeredPanningBtn->setChecked(cap);
	surroundBtn->setChecked(ss);
	effectsOffBtn->setChecked(off);
}

void MixerDialog::setEffectsOff()
{
	if ( !effectsOffBtn->isChecked() )
	{
		checkEffectButtons(true,false,false);
		myEmuConfig.volumeControl = SIDEMU_FULLPANNING;
		myEmuConfig.autoPanning = SIDEMU_NONE;
		setEffect();
	}
}

void MixerDialog::setStereoSurround()
{
	if ( !surroundBtn->isChecked() )
	{
		checkEffectButtons(false,true,false);
		myEmuConfig.volumeControl = SIDEMU_STEREOSURROUND;
		myEmuConfig.autoPanning = SIDEMU_NONE;
		setEffect();
	}
}

void MixerDialog::setCenteredPanning()
{
	if ( !centeredPanningBtn->isChecked() )
	{
		checkEffectButtons(false,false,true);
		myEmuConfig.volumeControl = SIDEMU_FULLPANNING;
		myEmuConfig.autoPanning = SIDEMU_CENTEREDAUTOPANNING;
		setEffect();
	}
}

void MixerDialog::setEffect()
{
	adjustMixerMode();
	myEmuEngine.setConfig(myEmuConfig);
	readAllVoiceVol();
	writeAllVoiceGainOnly();
}

void MixerDialog::presetButtons()
{
	int val;
	for (int v=0; v<voices; v++)
	{
		// Voice volume slider: 0=top, 256=bottom
		val = volSliders[v]->maxValue()-voiceMasterVol[v];
		volSliders[v]->setValue(val);
		
		// Panning slider: 0=left, 255=right
		// Choose pan-position dependend on right volume level.
		val = panSliders[v]->maxValue();
		if (myEmuConfig.volumeControl == SIDEMU_VOLCONTROL)
			val -= voiceHQvol[v].r;
		else if (myEmuConfig.autoPanning != SIDEMU_NONE)
			val = panSliders[v]->maxValue()/2;  // middle: irrelevant, but looks better
		else if (myEmuConfig.volumeControl == SIDEMU_FULLPANNING)
			val -= voiceFPvol[v].r;
		else
			val = panSliders[v]->maxValue()/2;  // middle: irrelevant, but looks better
		panSliders[v]->setValue(val);
	}

	// Preset LEDs.
	
	if (myEmuConfig.channels == SIDEMU_MONO)
	{
		fullPanningBtn->setEnabled(false);
		checkEffectButtons(false,false,false);
	}
	else
	{
		fullPanningBtn->setEnabled(true);
		
		if (myEmuConfig.volumeControl == SIDEMU_FULLPANNING)
		{
			if (myEmuConfig.autoPanning == SIDEMU_NONE)
				checkEffectButtons(true,false,false);
			else if (myEmuConfig.autoPanning == SIDEMU_CENTEREDAUTOPANNING)
				checkEffectButtons(false,false,true);
		}
		else
			checkEffectButtons(false,false,false);
	}
	
	if (myEmuConfig.volumeControl == SIDEMU_NONE)
	{
		checkMixerButtons(true,false,false);
		checkEffectButtons(false,false,false);
	}
	else if (myEmuConfig.volumeControl == SIDEMU_VOLCONTROL)
		checkMixerButtons(false,true,false);
	else if (myEmuConfig.volumeControl == SIDEMU_FULLPANNING)
		checkMixerButtons(false,false,true);
	else if (myEmuConfig.volumeControl == SIDEMU_STEREOSURROUND)
	{
		checkMixerButtons(false,false,true);
		checkEffectButtons(false,true,false);
	}
	
	adjustMixerMode();
}

void MixerDialog::adjustMixerMode()
{
	// Enable/Disable buttons.
	
	bool allowPanning = true;  // once ``false'', do not change
	bool allowEffects = true;
	bool allowMixer = true;
	
	if (myEmuConfig.volumeControl == SIDEMU_NONE)
	{
		allowMixer = false;
		allowEffects = false;
		allowPanning = false;
	}
	else if (myEmuConfig.volumeControl == SIDEMU_VOLCONTROL)
	{
		allowMixer = true;
		allowEffects = false;
		allowPanning = true;
	}
	else if (myEmuConfig.volumeControl == SIDEMU_STEREOSURROUND)
	{
		allowMixer = true;
		allowEffects = true;
		allowPanning = false;
	}
	else //if (myEmuConfig.volumeControl == SIDEMU_FULLPANNING)
	{
		allowMixer = true;
		allowEffects = true;
		allowPanning = true;
	}

	if (myEmuConfig.autoPanning != SIDEMU_NONE)
	{
		allowPanning = false;
	}
	
	if (myEmuConfig.channels == SIDEMU_MONO)
	{
		allowPanning = false;
		allowEffects = false;
	}

	if ( allowMixer )
		enableMixer();
	else
		disableMixer();
	
	if ( allowPanning )
		enablePanning();
	else
		disablePanning();
	
	if ( allowEffects )
		enableEffects();
	else
		disableEffects();
}

void MixerDialog::disableMixer()
{
	for (int i = 0; i < voices; i++)
	{
		muteButtons[i]->setEnabled(false);
		soloButtons[i]->setEnabled(false);
		volSliders[i]->setEnabled(false);
	}
}

void MixerDialog::enableMixer()
{
	for (int i = 0; i < voices; i++)
	{
		muteButtons[i]->setEnabled(true);
		soloButtons[i]->setEnabled(true);
		volSliders[i]->setEnabled(true);
	}
}

void MixerDialog::disablePanning()
{
	for (int i = 0; i < voices; i++)
		panSliders[i]->setEnabled(false);
}

void MixerDialog::enablePanning()
{
	for (int i = 0; i < voices; i++)
		panSliders[i]->setEnabled(true);
}

void MixerDialog::disableEffects()
{
	for (int i = 0; i < effects; i++)
		effectWidgets[i]->setEnabled(false);
}

void MixerDialog::enableEffects()
{
	for (int i = 0; i < effects; i++)
		effectWidgets[i]->setEnabled(true);
}

void MixerDialog::adjustPanningSliders()
{
	// Panning slider: 0=left, 255=right 
	// Choose pan-position depended on right volume level.
	int val = (myEmuEngine.getVoiceVolume(1)&255);
	voice1panSld->setValue(val);
	val = (myEmuEngine.getVoiceVolume(2)&255);
	voice2panSld->setValue(val);
	val = (myEmuEngine.getVoiceVolume(3)&255);
	voice3panSld->setValue(val);
	val = (myEmuEngine.getVoiceVolume(4)&255);
	voice4panSld->setValue(val);
}


void MixerDialog::currentSoloButtonOff()
{
	for (int i = 0; i < voices; i++)
	{
		if (i == (soloIsX-1))
		{
			soloButtons[i]->setOn(false);
			soloIsX = (-1);
		}
	}
}

void MixerDialog::allMuteSoloButtonsOff()
{
	for (int i = 0; i < voices; i++)
	{
		if ( !dontTouchMuteButtons )
			muteButtons[i]->setOn(false);
	}
	currentSoloButtonOff();
}

void MixerDialog::adjustAllMuteButtons()
{
	for (int i = 0; i < voices; i++)
	{
		if ( !dontTouchMuteButtons )
		{
			if (voiceMute[i]==0)
				muteButtons[i]->setOn(true);
			else
				muteButtons[i]->setOn(false);
		}
	}
}


void MixerDialog::newVoiceGain(int voice, int gain)
{
	if ((voice>=1)&&(voice<=4))
	{
		int vi = voice-1;
		voiceMasterVol[vi] = 256-gain;  // save the slider value
	}
}

void MixerDialog::newVoicePanPos(int voice, int leftLevel)
{
	if ((voice>=1)&&(voice<=4))
	{
		int vi = voice-1;
		if (myEmuConfig.channels == SIDEMU_STEREO)
		{
			if (myEmuConfig.volumeControl == SIDEMU_VOLCONTROL)
			{
				voiceHQvol[vi].l = leftLevel;
				voiceHQvol[vi].r = 255-leftLevel;
			}
			else
			{
				voiceFPvol[vi].l = leftLevel;
				voiceFPvol[vi].r = 255-leftLevel;
			}
		}
	}
}

void MixerDialog::disableVoice(int voice)
{
	if ((voice>=1)&&(voice<=4))
	{
		voiceMute[voice-1] = 0;  // mask, mute
		writeVoiceVol(voice);
	}
}

void MixerDialog::enableVoice(int voice)
{
	if ((voice>=1)&&(voice<=4))
	{
		voiceMute[voice-1] = 65535;  // unmask, no mute
		writeVoiceVol(voice);
	}
}

void MixerDialog::restoreAllVoices()
{
	for (int v = 1; v <= 4; v++)
		enableVoice(v);
}

// Read out current L/R volume levels with the purpose of using them to
// alter only the master volume level.
void MixerDialog::readAllVoiceVol()
{
	readDefaultVoiceVolume();
}

void MixerDialog::writeVoiceGainOnly(int voice)
{
	// Adjust only the master volume level.
	myEmuEngine.setVoiceVolume(voice,voiceInternalVol[voice-1].l,
							   voiceInternalVol[voice-1].r,
							   voiceMasterVol[voice-1]&voiceMute[voice-1]);
}

void MixerDialog::writeAllVoiceGainOnly()
{
	for (int v = 1; v <= 4; v++)
	{
		writeVoiceGainOnly(v);
	}
}

void MixerDialog::writeVoiceVol(int voice)
{
	if ((voice>=1)&&(voice<=4))
	{
		int vi = voice-1;
		// In mono mode, set voice volume regardless of whether mixing
		// mode is active.
		if (myEmuConfig.channels == SIDEMU_MONO)
		{
			myEmuEngine.setVoiceVolume(voice,255,0,
									   voiceMasterVol[vi]&voiceMute[vi]);
		}
		else
		{
			if (myEmuConfig.volumeControl == SIDEMU_VOLCONTROL)
			{
				myEmuEngine.setVoiceVolume(voice,voiceHQvol[vi].l,voiceHQvol[vi].r,
										   voiceMasterVol[vi]&voiceMute[vi]);
			}
			else if (myEmuConfig.volumeControl == SIDEMU_FULLPANNING)
			{
				if (myEmuConfig.autoPanning == SIDEMU_NONE)
					myEmuEngine.setVoiceVolume(voice,voiceFPvol[vi].l,voiceFPvol[vi].r,
											   voiceMasterVol[vi]&voiceMute[vi]);
				else
					writeVoiceGainOnly(voice);
			}
			else  // SIDEMU_STEREOSURROUND
			{
				writeVoiceGainOnly(voice);
			}
		}
	}
}

// -------------------------------------------------------------------- Slots

void MixerDialog::setVoice1Volume(int val)
{
	newVoiceGain(1,val);
	writeVoiceVol(1);
}

void MixerDialog::setVoice2Volume(int val)
{
	newVoiceGain(2,val);
	writeVoiceVol(2);
}

void MixerDialog::setVoice3Volume(int val)
{
	newVoiceGain(3,val);
	writeVoiceVol(3);
}

void MixerDialog::setVoice4Volume(int val)
{
	newVoiceGain(4,val);
	writeVoiceVol(4);
}

void MixerDialog::setVoice1Pan(int val)
{
	newVoicePanPos(1,255-val);
	writeVoiceVol(1);
	if ((myEmuConfig.channels==SIDEMU_STEREO)
		&&(myEmuConfig.volumeControl==SIDEMU_VOLCONTROL))
	{
		voice2panSld->setValue(255-val);
		newVoicePanPos(2,val);
		writeVoiceVol(2);
	}
}

void MixerDialog::setVoice2Pan(int val)
{
	newVoicePanPos(2,255-val);
	writeVoiceVol(2);
	if ((myEmuConfig.channels==SIDEMU_STEREO)
		&&(myEmuConfig.volumeControl==SIDEMU_VOLCONTROL))
	{
		voice1panSld->setValue(255-val);
		newVoicePanPos(1,val);
		writeVoiceVol(1);
	}
}

void MixerDialog::setVoice3Pan(int val)
{
	newVoicePanPos(3,255-val);
	writeVoiceVol(3);
	if ((myEmuConfig.channels==SIDEMU_STEREO)
		&&(myEmuConfig.volumeControl==SIDEMU_VOLCONTROL))
	{
		voice4panSld->setValue(255-val);
		newVoicePanPos(4,val);
		writeVoiceVol(4);
	}
}

void MixerDialog::setVoice4Pan(int val)
{
	newVoicePanPos(4,255-val);
	writeVoiceVol(4);
	if ((myEmuConfig.channels==SIDEMU_STEREO)
		&&(myEmuConfig.volumeControl==SIDEMU_VOLCONTROL))
	{
		voice3panSld->setValue(255-val);
		newVoicePanPos(3,val);
		writeVoiceVol(3);
	}
}

void MixerDialog::soloVoice1(bool val)
{
	if (val)
	{
		currentSoloButtonOff();
		enableVoice(1);
		disableVoice(2);
		disableVoice(3);
		disableVoice(4);
		adjustAllMuteButtons();
		soloIsX = 1;
	}
	else
	{
		soloIsX = (-1);
		if (!dontTouchMuteButtons)
		{
			restoreAllVoices();
			enableVoice(2);
			enableVoice(3);
			enableVoice(4);
			adjustAllMuteButtons();
		}
	}
}

void MixerDialog::soloVoice2(bool val)
{
	if (val)
	{
		currentSoloButtonOff();
		enableVoice(2);
		disableVoice(1);
		disableVoice(3);
		disableVoice(4);
		adjustAllMuteButtons();
		soloIsX = 2;
	}
	else
	{
		soloIsX = (-1);
		if (!dontTouchMuteButtons)
		{
			restoreAllVoices();
			enableVoice(1);
			enableVoice(3);
			enableVoice(4);
			adjustAllMuteButtons();
		}
	}
}

void MixerDialog::soloVoice3(bool val)
{
	if (val)
	{
		currentSoloButtonOff();
		enableVoice(3);
		disableVoice(1);
		disableVoice(2);
		disableVoice(4);
		adjustAllMuteButtons();
		soloIsX = 3;
	}
	else
	{
		soloIsX = (-1);
		if (!dontTouchMuteButtons)
		{
			restoreAllVoices();
			enableVoice(1);
			enableVoice(2);
			enableVoice(4);
			adjustAllMuteButtons();
		}
	}
}

void MixerDialog::soloVoice4(bool val)
{
	if (val)
	{
		currentSoloButtonOff();
		enableVoice(4);
		disableVoice(1);
		disableVoice(2);
		disableVoice(3);
		adjustAllMuteButtons();
		soloIsX = 4;
	}
	else
	{
		soloIsX = (-1);
		if (!dontTouchMuteButtons)
		{
			restoreAllVoices();
			enableVoice(1);
			enableVoice(2);
			enableVoice(3);
			adjustAllMuteButtons();
		}
	}
}

void MixerDialog::muteVoice1(bool val)
{
	dontTouchMuteButtons = true;
	if (val)
	{
		currentSoloButtonOff();
		disableVoice(1);
		adjustAllMuteButtons();
	}
	else
	{
		currentSoloButtonOff();
		enableVoice(1);
		adjustAllMuteButtons();
	}
	dontTouchMuteButtons = false;
}

void MixerDialog::muteVoice2(bool val)
{
	dontTouchMuteButtons = true;
	if (val)
	{
		currentSoloButtonOff();
		disableVoice(2);
		adjustAllMuteButtons();
	}
	else
	{
		currentSoloButtonOff();
		enableVoice(2);
		adjustAllMuteButtons();
	}
	dontTouchMuteButtons = false;
}

void MixerDialog::muteVoice3(bool val)
{
	dontTouchMuteButtons = true;
	if (val)
	{
		currentSoloButtonOff();
		disableVoice(3);
		adjustAllMuteButtons();
	}
	else
	{
		currentSoloButtonOff();
		enableVoice(3);
		adjustAllMuteButtons();
	}
	dontTouchMuteButtons = false;
}

void MixerDialog::muteVoice4(bool val)
{
	dontTouchMuteButtons = true;
	if (val)
	{
		currentSoloButtonOff();
		disableVoice(4);
		adjustAllMuteButtons();
	}
	else
	{
		currentSoloButtonOff();
		enableVoice(4);
		adjustAllMuteButtons();
	}
	dontTouchMuteButtons = false;
}
