/*
  A simple producer for images.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <producer/image/imageGenerator.h>

ImageGenerator::ImageGenerator() {
  internal=new QPixmap();
  current=new QPixmap();
  cache=new QPixmap();

  config=new DeviceConfig();
  VideoStream* videoStream=config->getVideoStream();
  statusInfo=videoStream->getStatusInfo();

}


ImageGenerator::~ImageGenerator() {
  delete internal;
  delete current;
  delete cache;
  delete config;
}


int ImageGenerator::updateDeviceConfig(DeviceConfig* newConfig) {
  VideoStream* videoStream=newConfig->getVideoStream();
  VideoInfo* videoInfo;
  MemChunk* memChunk;
  cout <<"updateDeviceConfig"<<endl;
  if (statusInfo->getChange()) {
    statusInfo->print();
    videoStream->setStatusInfo(statusInfo);
    newConfig->setStatusInfo(statusInfo);
    statusInfo->setChange(false);

    cout << "newConfig"<<endl;
    newConfig->getStatusInfo()->print();

    return _THREAD_DELIVER;
  }


  videoInfo=videoStream->getVideoInfo();
  memChunk=videoInfo->getMemChunk();
  memChunk->waitForUnlock();
  
  bitBlt(current,0,0,internal,scrollPos,0,width-scrollPos,height);
  scrollPos++;
  if (scrollPos>width) {
    scrollPos=0;
  }
  bitBlt(current,width-scrollPos,0,internal,0,0,scrollPos,height);


  videoInfo->setPixmap(current);

  usleep(500);
  return _THREAD_DELIVER;
}


int ImageGenerator::open(char* filename ) {
  cout << "ImageGenerator -------- open"<<endl;
  setThreadState(_NOT_ALLOW_GENERATOR_ENTER);
  statusInfo->setStatus(_STATUS_PLAYING);
  internal->load(filename);
  width=internal->width();
  height=internal->height();
  current->resize(width,height);
  scrollPos=0;
  setThreadState(_ALLOW_GENERATOR_ENTER);

  return true;
}

/**
   The way we use the images this must stop
   the deliver thread.
   A more powerfull image handling system may change this.
   But the whole image stuff is demo only.
*/
int ImageGenerator::jump(int percent) {
  return true;
}



void ImageGenerator::setThreadState(int msg) {
  ThreadNotifier* client;
  client=getThreadNotifier();     // our "phone" to the thread :-)

  client->sendSyncMessage(msg);
  
  cout << "setThreadState:"<<msg<<endl;
}


void ImageGenerator::dataUpdate() {
  if (statusInfo->getChange() == true) {
    cout << "statusInfo change is true"<<endl;
    setThreadState(_ALLOW_GENERATOR_ENTER);
  }
}

