/*
  property description of a decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __DECODER_ID_H
#define __DECODER_ID_H

#include <iostream.h>
#include <string.h>

/**
   Abstraction class for decoders.
   <p>
   Never make an instance of this class directly
   <p>
   Make an instance of this over a method call in amplifier !
   The reson is, that amplifier needs a few "secret" switches.

*/


class DecoderID {

  int id;
  int argn;
  char** args;

 public:
  DecoderID(int id,int argn,char** args);
  ~DecoderID();

  // adds and duplicate this string
  void addArgs(char* str);
  int getID();
  void setID(int id);

  int getArgn();
  char* getArgs(int i);
  void copyTo(DecoderID* dest);
  int hasArg(char* arg);

  /** 
      equality by commandline options :-)
      and yes, the equallity tests for left and right equality :-)))
      but it only checks for syntactical equality, sematics
      like -a -o == -oa are not tested.
  */

  int argumentEqualTo(DecoderID* cmp);
  void clear();
  void print();

};

#endif
