/*
  streams data to harddisk.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __WAVFILEWRITER_H
#define __WAVFILEWRITER_H


#include <devices/outputDevice.h>
#include <stdio.h>
#include <errno.h>

#define _WAVFILEDEVICE_SIGNAL_ERROR     1

/**
   The wav write method come from cdparanoia.
*/

class WavFileDevice : public OutputDevice {

  FILE* file;
  int lEnabled;

 public:

  WavFileDevice();
  ~WavFileDevice();

  char* getNodeName();
  int getEnabled();
  void setEnabled(int lEnable);

  char* getFileName();
  void setTargetDirectory(char* dir);
  long getByteCounter();
  int getErrno();
  void setStopIsEOF(int lStopIsEof);

  void writeIn(NodeDevice* source,DeviceConfig* config);

 private:
  void WriteEmptyWavHeader(FILE* f);
  void WriteLengthWavHeader(FILE* file,long bytes);
  void PutNum(long num,FILE* file,int endianness,int bytes);
  int doOpen();
  int isOpen();
  void doClose();
  void createFileName(Buffer* target);

  int writerThreadErrno;
  int lOpen;
  int lStopIsEof;
  long bytecounter;
  Buffer* dirName;
  Buffer* fileName;
  Buffer* currentFile;
  MusicInfo* musicInfo;
};




#endif
