/*
  changes the volume on your hardware
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "nativeMixerDevice.h"


NativeMixerDevice::NativeMixerDevice(const char* device):OutputDevice("NativeMixerDevice") {
  audioWrapper=new AudioWrapper();
  volumeInfo=new VolumeInfo();
  lneedInit=true;
}


NativeMixerDevice::~NativeMixerDevice() {
  delete audioWrapper;
  delete volumeInfo;
}




int NativeMixerDevice::open() {
  if (isOpen()==false) {
    audioWrapper->openMixer();
    lneedInit=true;
 }
  return true;
}


int NativeMixerDevice::close() {
  if (isOpen()==true) {
    audioWrapper->closeMixer();
  }
  return true;
}


int NativeMixerDevice::isOpen() {
  return audioWrapper->isOpenMixer();
}
  
char* NativeMixerDevice::getNodeName() {
  return "NativeMixerDevice";
}


void NativeMixerDevice::writeIn(NodeDevice* source,DeviceConfig* config) {
  AudioStream* audioStream=config->getAudioStream();

  VolumeInfo* volumeInfoStream=audioStream->getVolumeInfo();

  if (!volumeInfoStream->equals(volumeInfo) || lneedInit) {
    float leftVolume=volumeInfoStream->getLeftVolume();
    float rightVolume=volumeInfoStream->getRightVolume();
    volumeInfoStream->copyTo(volumeInfo);
    if (audioWrapper->isOpenMixer()) {
      audioWrapper->setVolume(leftVolume,rightVolume);
    }
    lneedInit=false;
  }


}

  
