/*
  delivers general status/info messages of the stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <devices/audioStreamInfoDevice.h>


AudioStreamInfoDevice::AudioStreamInfoDevice():OutputDevice("AudioStreamInfoDevice") {
  statusInfo=new StatusInfo();
  musicInfo=new MusicInfo();
  timeInfo=new TimeInfo();
  audioInfo=new AudioInfo();
  audioBuffer=new AudioBuffer();

  eventMask=_AUDIOSTREAMINFO_STATUS_CHANGE |
            _AUDIOSTREAMINFO_MUSIC_CHANGE |
            _AUDIOSTREAMINFO_TIME_CHANGE |
            _AUDIOSTREAMINFO_BUFFERFILL_CHANGE |
            _AUDIOSTREAMINFO_AUDIO_CHANGE ;
            
  // no "drops" of events allowed!
  getEventQueue()->setNotifyMode(_NOTIFY_ALL);
}


AudioStreamInfoDevice::~AudioStreamInfoDevice() {
  delete statusInfo;
  delete musicInfo;
  delete timeInfo;
  delete audioInfo;
  delete audioBuffer;
}


char* AudioStreamInfoDevice::getNodeName() {
  return "AudioStreamInfoDevice";
}


StatusInfo* AudioStreamInfoDevice::getStatusInfo() {
  return statusInfo;
}


MusicInfo* AudioStreamInfoDevice::getMusicInfo() {
  return musicInfo;
}


TimeInfo* AudioStreamInfoDevice::getTimeInfo() {
  return timeInfo;
}


AudioInfo* AudioStreamInfoDevice::getAudioInfo() {
  return audioInfo;
}


AudioBuffer* AudioStreamInfoDevice::getAudioBuffer() {
  return audioBuffer;
}


void AudioStreamInfoDevice::setEventMask(int mask) {
  eventMask=mask;
}


int AudioStreamInfoDevice::getEventMask() {
  return eventMask;
}


void AudioStreamInfoDevice::writeIn(NodeDevice* source,DeviceConfig* buf) {
  AudioStream* audioStream=buf->getAudioStream();
  StatusInfo* statusInfoStream=audioStream->getStatusInfo();
  TimeInfo* timeInfoStream=audioStream->getTimeInfo();
  AudioInfo* audioInfoStream=audioStream->getAudioInfo();
  AudioBuffer* audioBufferStream=audioStream->getAudioBuffer();
  MusicInfo* musicInfoStream=audioStream->getMusicInfo();
  
  if (eventMask & _AUDIOSTREAMINFO_BUFFERFILL_CHANGE) {
    if (audioBufferStream->getChange()) {
      audioBufferStream->copyTo(audioBuffer);
      getEventQueue()->sendEvent(_AUDIOSTREAMINFO_BUFFERFILL_CHANGE);
    }
  }

  if (eventMask & _AUDIOSTREAMINFO_TIME_CHANGE) {
    if (timeInfoStream->getChange()) {
      timeInfoStream->copyTo(timeInfo);
      getEventQueue()->sendEvent(_AUDIOSTREAMINFO_TIME_CHANGE);
    }
  }


  if (eventMask & _AUDIOSTREAMINFO_STATUS_CHANGE) {
    if (statusInfoStream->getChange()) {
      statusInfoStream->copyTo(statusInfo);
      getEventQueue()->sendEvent(_AUDIOSTREAMINFO_STATUS_CHANGE);
    }
  }

  if (eventMask & _AUDIOSTREAMINFO_MUSIC_CHANGE) {
    if (musicInfoStream->getChange()) {
      musicInfoStream->copyTo(musicInfo);
      getEventQueue()->sendEvent(_AUDIOSTREAMINFO_MUSIC_CHANGE);
    }
  }

  if (eventMask & _AUDIOSTREAMINFO_AUDIO_CHANGE) {
    if (audioInfoStream->getChange()) {
      audioInfoStream->copyTo(audioInfo);
      getEventQueue()->sendEvent(_AUDIOSTREAMINFO_AUDIO_CHANGE);
    }
  }
}


