/*
  base class for all streams
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <deviceConfig/stream/stream.h>


Stream::Stream() {
  producer=NULL;
  id=__STREAM_UNKNOWN;
  statusInfo=new StatusInfo();
}


Stream::~Stream() {
  delete statusInfo;
}


void Stream::setId(int id) {
  this->id=id;
}


int Stream::getId() {
  return id;
}


void* Stream::getStreamProducer() {
  return producer;
}


void Stream::setStreamProducer(void* streamProducer) {
  this->producer=streamProducer;
}



void Stream::setStatusInfo(StatusInfo* aStatusInfo) {
  aStatusInfo->copyTo(statusInfo);
}


StatusInfo* Stream::getStatusInfo() {
  return statusInfo;
}


void Stream::copyTo(Stream* dest) {
  dest->setStreamProducer(getStreamProducer());
  dest->setId(getId());
  dest->setStatusInfo(getStatusInfo());
}

  
void Stream::forward() {
  statusInfo->setChange(false);
}

void Stream::print() {
  statusInfo->print();
}
