/*
  stores deviceConfigFifos (each streamProducer in a seperate column)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <deviceConfig/multiQueueFifo.h>



MultiQueueFifo::MultiQueueFifo() {
  int i;

  confArray=new DeviceConfigArray();
  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) {
    fifoQueue[i]=NULL;
  }
  queueCount=0;  
}


MultiQueueFifo::~MultiQueueFifo() {
  int i;

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) {
    if (fifoQueue[i] != NULL) {
      delete fifoQueue[i];
    }
  }
  delete confArray;
}


void MultiQueueFifo::enqueue(NodeDevice* id,DeviceConfig* config) {
  int pos=findQueue(id);
  if (pos == -1) {
    cout << "remove source called, but source not found!"<<endl;
    exit(-1);
  }
  fifoQueue[pos]->enqueue(config);
}


int MultiQueueFifo::canSimultaneousDequeue() {
  int i;
  int fillgrade;
  int validCounter=0;
  int status;



  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      validCounter++;
      fillgrade=fifoQueue[i]->getFillgrade();
      if (fillgrade > 0) {
	continue;
      }
      status=fifoQueue[i]->getStatus();
      if (status == _STATUS_STOPPED) {
	if (fifoQueue[i]->getWaitForStoppedSource() == false) {
	  continue;
	}
      }
      if (status == _STATUS_PAUSED) {
	if (fifoQueue[i]->getWaitForPausedSource() == false) {
	  continue;
	}
      }
      return false;
    }
  }
  return true;
}


DeviceConfigArray* MultiQueueFifo::multiDequeue() {
  int i;
  DeviceConfigFifo* fifo;
  int fillgrade;
  int entries=0;

  confArray->clear();

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      fifo=fifoQueue[i];
      fillgrade=fifo->getFillgrade();
      if (fillgrade > 0) {
	DeviceConfig* deviceConfig=fifo->dequeue();
	confArray->setDeviceConfigAt(entries,deviceConfig);
	entries++;
      }
    }
  }
  confArray->setEntries(entries);
  return confArray;
}


void MultiQueueFifo::multiForward() {
  int i;
  DeviceConfigFifo* fifo;

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      if (fifoQueue[i]->getDequeue() == true) {
	fifo=fifoQueue[i];
	fifo->forwardQueue();
      }
    }
  }  
}


int MultiQueueFifo::findQueue(NodeDevice* nodeDevice) {
  int i;
  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      if (fifoQueue[i]->getID() == nodeDevice) {
	return i;
      }
    }
  }
  return -1;
}


int MultiQueueFifo::findEmpty() {
  int i;

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] == NULL) {
      return i;
    }
  }
  return -1; 
}



void MultiQueueFifo::sigHUP() {
  int i;

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      if (fifoQueue[i]->overflowDanger() == false) {
	return;
      }
    }
  }
  // all are sleeping then the next who enters
  // is guaranteend that the canSimultaneous dequeu
  // succeds
  
  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      fifoQueue[i]->removeOverflowDangerLock();
      return;
    }
  }
} 


void MultiQueueFifo::insert(DeviceConfigFifo* deviceConfigFifo) {
  int pos=findEmpty();
  if (pos == -1) {
    cout << "fatal error source overflow->MultiQueueFifo::requestQueue"<<endl;
    cout << "Maximum sources allowed: "<<_MAX_QUEUE_ENTRIES<<endl;
    exit(-1);
  }
  fifoQueue[pos]=deviceConfigFifo;
  queueCount++;
}



void MultiQueueFifo::remove(NodeDevice* id) {
  int pos=findQueue(id);
  if (pos == -1) {
    cout << "remove source called, but source not found!"<<endl;
    exit(-1);
  }
  delete fifoQueue[pos];
  fifoQueue[pos]=NULL;
  queueCount--;
  sigHUP();
}
 

int MultiQueueFifo::getQueueCount() {
  return queueCount;
}


int MultiQueueFifo::isEmpty() {
  int i;
  int fillgrade;


  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      fillgrade=fifoQueue[i]->getFillgrade();
      if (fillgrade > 0) {
	return false;
      }
    }
  }
  return true;
}


void MultiQueueFifo::clear(NodeDevice* id) {
  int pos=findQueue(id);
  if (pos == -1) {
    return;
  }
  fifoQueue[pos]->clear();
  return;
}



int MultiQueueFifo::isStopped() {
  int i;
  int status;

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      status=fifoQueue[i]->getStatus();
      if (status != _STATUS_STOPPED) {
	return false;
      }
    }
  }
  return true;
}



int MultiQueueFifo::isPaused() {
  int i;
  int status;

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    if (fifoQueue[i] != NULL) {
      status=fifoQueue[i]->getStatus();
      if (status != _STATUS_PAUSED) {
	return false;
      }
    }
  }
  return true;
}


void MultiQueueFifo::print() {
  int i;
  int fillgrade;
  int validCounter=0;
  int status;

  for(i=0;i<_MAX_QUEUE_ENTRIES;i++) { 
    cout<< "i:"<<i;
    if (fifoQueue[i] != NULL) {
      printf("%p",fifoQueue[i]);
      validCounter++;
      fillgrade=fifoQueue[i]->getFillgrade();
      cout <<" fillgrade:"<<fillgrade;
      status=fifoQueue[i]->getStatus();
      cout << "status:"<<status<<endl;
    } else {
      cout <<"NULL"<<endl;
    }
  }
}

