/*
  stores the status of the stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <deviceConfig/info/statusInfo.h>


StatusInfo::StatusInfo() {
  status=_STATUS_STOPPED;
  lEof=false;
}


StatusInfo::~StatusInfo() {
}



int StatusInfo::getStatus() {
  return status;
}


void StatusInfo::setStatus(int status) {
  this->status=status;
  setChange(true);
}


void StatusInfo::copyTo(StatusInfo* dest) {
  dest->setStatus(getStatus());
  dest->setEOF(getEOF());
  dest->setChange(getChange());
}

int StatusInfo::getEOF() {
  return lEof;
}


void StatusInfo::setEOF(int eof) {
  this->lEof=eof;
  setChange(true);
}



void StatusInfo::print() {
  cout <<"StatusInfo: ";
  switch (status) {
  case _STATUS_PLAYING : {
    cout <<" playing"<<endl;
    break;
  }
  case _STATUS_PAUSED : {
    cout <<" pause"<<endl;
    break;
  }
  case _STATUS_STOPPED : {
    cout <<" stopped"<<endl;
    break;
  } 
  default:
    cout << "unknown statue: "<<status<<endl;
  }
  cout << "change is:"<<getChange()<<endl;
}


