/*
  mapping between file extensions and a possible decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <extension.h>

static PtrArray pattern2decoder(17);
static int forceDecoder=_EXTENSION_AUTO;
static int wavDecoder=_EXTENSION_WAV;
static int mp3Decoder=_EXTENSION_MP3;
static int mpegDecoder=_EXTENSION_MPEG;


Extension::Extension() {
}


Extension::~Extension() {
}



int Extension::getDecoderType(const char* filename) {
  char *ending;


  ending=strrchr(filename, '.');  
  if (ending == NULL) {
    return _EXTENSION_UNKNOWN;
  }
  if (strlen(ending) == 0) {
    return _EXTENSION_UNKNOWN;
  }
  // len of ending >= 1  !!

  int n=pattern2decoder.getFillgrade();
  int i;
  int foundID=_EXTENSION_UNKNOWN;
  for(i=0;i<n;i++) {
    char* pattern=(char*)pattern2decoder.getPtrAt(i);
    int len=strlen(pattern);
    if (strlen(ending+1) < len) {
      len=strlen(ending+1);
    }
    
    if (strncasecmp(ending+1,pattern,len)==0) {
      // this makes sure we check all
      // registered pattern and if we find more than one
      // we return "unknown"
      if (foundID != _EXTENSION_UNKNOWN) {
	foundID=_EXTENSION_UNKNOWN;
	break;
      }
      foundID=pattern2decoder.getIdAt(i);
    }
  }
  return foundID;
}


void Extension::addExtension(char* pattern,int decoderType) {
  if (decoderType == _EXTENSION_WAV) {
    pattern2decoder.add(wavDecoder,pattern);
    return;
  }
  if (decoderType == _EXTENSION_MP3) {
    pattern2decoder.add(mp3Decoder,pattern);
    return;
  }
  if (decoderType == _EXTENSION_MPEG) {
    pattern2decoder.add(mpegDecoder,pattern);
    return;
  }
  cout << "unknown extension <-> decoder added"<<endl;
}


void Extension::setForceDecoder(int decoderType) {
  forceDecoder=decoderType;
}


int Extension::getForceDecoder() {
  return forceDecoder;
}
