/*
  base class for the player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */

#include "playerPlugin.h"

static void *playerThread(void *arg){
  ((PlayerPlugin*)arg)->idleThread();
  return NULL;
}   


PlayerPlugin::PlayerPlugin(){
  input=NULL;
  output=NULL;

  pthread_cond_init(&decoderCond,NULL);
  pthread_mutex_init(&decoderChangeMut,NULL);
  pthread_mutex_init(&decoderMut,NULL);
  pthread_mutex_init(&workMut,NULL);

  lCreatorLoop=true;
  lDecoderLoop=false;
  linDecoderLoop=false;
  leof=true;
  lDecode=false;
  lhasLength=false;
  lAutoPlay=false;

  pluginInfo=new PluginInfo();

  pthread_create(&tr,NULL,playerThread,this);
  while(linDecoderLoop==false) {
    usleep(500);
  }

}


PlayerPlugin::~PlayerPlugin(){
  void* ret;
  decoderLock();
  lDecoderLoop=false;
  lCreatorLoop=false;
  lDecode=false;
  decoderUnlock();
  pthread_join(tr,&ret);
}

  
void PlayerPlugin::close(){
  decoderLock();
  lDecode=false;
  lDecoderLoop=false;
  lhasLength=false;
  decoderUnlock();
  while(linDecoderLoop==false) {
    usleep(500);
  }
}


void PlayerPlugin::pause() {
  decoderLock();
  lDecode=false;
  decoderUnlock();

}


void PlayerPlugin::play() {
  decoderLock();
  lDecode=true;
  decoderUnlock();
}

void PlayerPlugin::workLock() {
  pthread_mutex_lock(&workMut);
}

void PlayerPlugin::workUnlock() {
  pthread_mutex_unlock(&workMut);
}

void PlayerPlugin::decoderLock() {
  pthread_mutex_lock(&decoderChangeMut);
  pthread_mutex_lock(&decoderMut);
}

void PlayerPlugin::decoderUnlock() {
  pthread_cond_signal(&decoderCond);
  pthread_mutex_unlock(&decoderChangeMut);
  pthread_mutex_unlock(&decoderMut);
}



int PlayerPlugin::seek(int second) {
  cout << "plugin does not support seek"<<endl;
  return false;
}




void PlayerPlugin::setOutputPlugin(OutputStream* output) {
  this->output=output;
}


int PlayerPlugin::setInputPlugin(InputStream* input) {
  decoderLock();
  this->input=input;

  if (!input) {
    cout << "input is NULL"<<endl;
    decoderUnlock();
    return false;
  }
  cout << "pluginInfo set url -s"<<endl;
  pluginInfo->setUrl(input->getUrl());
  cout << "pluginInfo set url -e"<<endl;

  lDecoderLoop=true;
  lDecode=false;
  leof=false;
  if (lAutoPlay) {
    lDecode=true;
  }


  decoderUnlock();
  while(linDecoderLoop==true) {
    usleep(500);
  }
  return true;
}


void PlayerPlugin::config(char* key, char* value) {
  if (strcmp(key,"-p")==0) {
    lAutoPlay=true;
  }
  if (strcmp(key,"decode")==0) {
    if (strcmp(value,"off")==0) {
      lDecode=false;
    }
  }  
}


int PlayerPlugin::getStreamState() {
  if (leof) {
    return _STREAM_STATE_EOF;
  } 
  return _STREAM_STATE_NOT_EOF;
}


void PlayerPlugin::decoder_loop() {
  cout << "direct call decoder loop"<<endl;
  usleep(1000);
}


void* PlayerPlugin::idleThread() {
  pthread_mutex_lock(&decoderMut);
  while(lCreatorLoop) {
    linDecoderLoop=true;
    if (pthread_mutex_trylock(&decoderChangeMut) == EBUSY) {
      pthread_cond_wait(&decoderCond,&decoderMut);
      continue;
    }
    pthread_mutex_unlock(&decoderChangeMut);
    if (lDecoderLoop) {
      leof=false;
      linDecoderLoop=false;
      decoder_loop();
    } else {
      pthread_cond_wait(&decoderCond,&decoderMut);
    }
  }
  pthread_mutex_unlock(&decoderMut);
  return NULL;
}


PluginInfo* PlayerPlugin::getPluginInfo() {
  return pluginInfo;
}
