/*
  generic output class
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __OUTPUTSTREAM_H
#define __OUTPUTSTREAM_H

#include <iostream.h>
#include "../inputPlugin/timeStampArray.h"
#include "../playerPlugin/pluginInfo.h"

class OutputStream {

 public:
  OutputStream();

  virtual ~OutputStream();

  // Audio Output

  virtual int audioSetup(int frequency,int stereo,
			 int sign,int big,int sixteen);
  virtual void audioClose(void);
  virtual int audioPlay(TimeStamp* startStamp,
			TimeStamp* endStamp,char *buffer, int size);
  virtual void audioFlush();

  virtual int getPreferredDeliverSize();

  // Video Output

  virtual int openWindow(int width, int height,char *title);
  virtual void closeWindow();
  virtual void flushWindow();
  
  virtual void putImage(TimeStamp* startStamp,
			TimeStamp* endStamp,struct Picture* pic);
  virtual int getFrameusec();
  virtual int getDepth();
  virtual int getOutputInit();
  virtual void setOutputInit(int lInit);

  // Info Output
  virtual void writeInfo(PluginInfo* pluginInfo);


  // config Output
  virtual void config(char* key, char* value);

};
#endif
