/*
 * Copyright (c) 1995 The Regents of the University of California.
 * All rights reserved.
 * 
 */

/* Range values for lum, cr, cb. */


#include <stdio.h>
#include <iostream.h>
#include <math.h>

extern int LUM_RANGE;
extern int CR_RANGE;
extern int CB_RANGE;

#define CB_BASE 1
#define CR_BASE (CB_BASE*CB_RANGE)
#define LUM_BASE (CR_BASE*CR_RANGE)

#define TABTYPE short

#ifdef SIXTYFOUR_BIT
#define PIXVAL long
#else
#define PIXVAL int
#endif


extern unsigned char pixel[256];
extern unsigned long wpixel[256];
extern int *lum_values;
extern int *cr_values;
extern int *cb_values;

/* Gamma correction stuff */
extern int gammaCorrectFlag;
extern double gammaCorrect;

/* Chroma correction stuff */
extern int chromaCorrectFlag;
extern double chromaCorrect;


#define Min(x,y) (((x) < (y)) ? (x) : (y))
#define Max(x,y) (((x) > (y)) ? (x) : (y))

#define GAMMA_CORRECTION(x) ((int)(pow((x) / 255.0, 1.0 / gammaCorrect) * 255.0))
#define CHROMA_CORRECTION256(x) ((x) >= 128 \
                        ? 128 + Min(127, (int)(((x) - 128.0) * chromaCorrect)) \
                        : 128 - Min(128, (int)((128.0 - (x)) * chromaCorrect)))
#define CHROMA_CORRECTION128(x) ((x) >= 0 \
                        ? Min(127,  (int)(((x) * chromaCorrect))) \
                        : Max(-128, (int)(((x) * chromaCorrect))))
#define CHROMA_CORRECTION256D(x) ((x) >= 128 \
                        ? 128.0 + Min(127.0, (((x) - 128.0) * chromaCorrect)) \
                        : 128.0 - Min(128.0, (((128.0 - (x)) * chromaCorrect))))
#define CHROMA_CORRECTION128D(x) ((x) >= 0 \
                        ? Min(127.0,  ((x) * chromaCorrect)) \
                        : Max(-128.0, ((x) * chromaCorrect)))




// Prototypes:

// dither.cpp
extern void initDither();
extern void initColor();
void ConvertColor(unsigned int l, unsigned int cr, unsigned int cb,
		  unsigned char* r, unsigned char* g, unsigned char* b);



// ditherColor.cpp
extern void initColorDither(int thirty2);
extern void ditherImageColor16 (unsigned char *lum , unsigned char *cr ,
				unsigned char *cb , unsigned char *out ,
				int rows , int cols ,int offset);
extern void ditherImageColor32 (unsigned char *lum , unsigned char *cr ,
				unsigned char *cb , unsigned char *out ,
				int rows, int cols,int mod);


// ditherOrdered.cpp
void initOrderedDither();
void ditherImageOrdered (unsigned char *lum , unsigned char *cr , 
			 unsigned char *cb , unsigned char *out ,
			 int h , int w);

// The mmx dither routine come from NIST
// NIST is an mpeg2/dvd player
// more: http://home.germany.net/100-5083/
extern void  ditherBlock(unsigned char *lum, 
			 unsigned char *cr, 
			 unsigned char *cb,
			 unsigned char *out,
			 int rows, int cols, int mod);

extern void dither32_mmx(unsigned char* lum,
			 unsigned char* cr,
			 unsigned char* cb,
			 unsigned char* out,
			 int rows,
			 int cols,
			 int mod);
     
extern "C" void dither32(unsigned char* lum,
			 unsigned char* cr,
			 unsigned char* cb,
			 unsigned char* out,
			 int rows,
			 int cols,
			 int mod,
			 PIXVAL* r_2_pix,
			 PIXVAL* g_2_pix,
			 PIXVAL* b_2_pix,
			 TABTYPE* Cr_r_tab,
			 TABTYPE* Cr_g_tab,
			 TABTYPE* Cb_g_tab,
			 TABTYPE* Cb_b_tab,
			 TABTYPE* L_tab);
     

