/*
  mpg I video/audio player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "mpgPlugin.h"

#define AUDIO_PACKET_SIZE 2



MpgPlugin::MpgPlugin() {
  splayPlugin=NULL;
  mpegplayPlugin=NULL;
  mpegLength=NULL;
  lCalcLength=true;
  downSampleFlag=false;
  monoFlag=false;


  timeStampVirtual=new TimeStamp();
  timeStamp=new TimeStamp();
  sequenceParse=NULL;

  audioPacket=new PacketDescription();
  audioPacketArray=new PacketArray(AUDIO_PACKET_SIZE);
}


MpgPlugin::~MpgPlugin() {
  

}



void MpgPlugin::startSubPlugins() {
  restartSPlay();
  restartMPEGPlay();
  resetCounters();

}


void MpgPlugin::removeSubPlugins() {

  shutDownSPlay();
  shutDownMPEGPlay();

}

 
void MpgPlugin::decoder_loop() {
  lInit=false;
  first=true;
  if (input == NULL) {
    cout << "MPGPlugin::decoder_loop input is NULL"<<endl;
    exit(0);
  }
  if (output == NULL) {
    cout << "MPGPlugin::decoder_loop output is NULL"<<endl;
    exit(0);
  }



  Packet* packet=new Packet();


  if (lCalcLength) {
    cout << "calculatin lengt in mpg"<<endl;
    mpegLength=new MpegLength(input);
    mpegLength->startCalc();

  }


  pluginInfo->setLength(getSongLength());
  output->writeInfo(pluginInfo);



  sequenceParse=NULL;

  
  startSubPlugins();
  lhasLength=true;

  if (firstSync(packet) == false) {
    lDecoderLoop=false;
    leof=true;
  }


  while(lDecoderLoop && lCreatorLoop) {
    if (pthread_mutex_trylock(&decoderChangeMut) == EBUSY) {
      pthread_cond_wait(&decoderCond,&decoderMut);
      continue;
    }
    pthread_mutex_unlock(&decoderChangeMut);
    if (lDecode) {
      
      // init is true
      get_more_data(packet);


      if (input->eof()){
	while( (splayPlugin->getStreamState()==_STREAM_STATE_NOT_EOF) ||
	       (mpegplayPlugin->getStreamState()==_STREAM_STATE_NOT_EOF) ) {
	  cout << "wait for finish"<<endl;
	  usleep(1000000);
	  splayInput->close();
	  mpegplayInput->close();

	}
	lDecoderLoop=false;
	leof=true;
	continue;
      }
    } else {
      pthread_cond_wait(&decoderCond,&decoderMut);
   }
  }
  delete packet;
  packet=NULL;
  delete mpegLength;
  mpegLength=NULL;
  output->audioFlush();
  output->flushWindow();
  pthread_mutex_unlock(&decoderMut);

  cout << "removeSubPlugins -s"<<endl;
  removeSubPlugins();
  cout << "removeSubPlugins -e"<<endl;
  if (sequenceParse != NULL) {
    cout << "deleteing sequenceParse"<<endl;
    
    delete sequenceParse;
    sequenceParse=NULL;
  }
  cout << "leave"<<endl;
}


int MpgPlugin::firstSync(Packet* packet) {


  unsigned int startCode;

  cout << "MpgPlugin::firstSync"<<endl;
  if (packet->syncStream(startCode,input)==false) {
    cout << "no sync insert iso endcode "<<endl;
    return false;
  }

  int layer=packet->getSysLayer();
  if (input->eof()) {
    cout << "input->eof end"<<endl;
    return false;
  }
  if (layer == _PACKET_UNKNOWN_LAYER) {
    cout << "no layer found"<<endl;
    return false;
  }
  if (layer == _PACKET_NO_SYSLAYER) {
    cout << "no syslayer just video"<<endl;
    // insert everything into videoplayer
    unsigned int startCodeRaw=htonl(startCode);
    mpegplayInput->write((char*)&startCodeRaw,4);
  }
  return true;
}



void MpgPlugin::shutDownMPEGPlay() {
  mpegplayInput->close();
  mpegplayPlugin->pause();
  // now save the sequence info
  // this is necessary, because some streams
  // only have excatly one information in it.
  SequenceParse* sequenceInfo=mpegplayPlugin->getSequenceInfo();
  if (sequenceParse == NULL) {
    printf("sequenceInfo:%8x\n",sequenceInfo);
    if (sequenceInfo != NULL) {
      sequenceParse=new SequenceParse(output);
      sequenceParse->recreate(sequenceInfo->getSequence());
    }
  }

  mpegplayPlugin->close();
  delete mpegplayPlugin;
  delete mpegplayInput;
}


void MpgPlugin::restartMPEGPlay() {

  mpegplayPlugin=new MpegPlugin(sequenceParse);
  // no timelength calculation for this plugin
  mpegplayPlugin->config("-c","");
  // autoplay on after setInputPlugin
  mpegplayPlugin->config("-p","");
  mpegplayInput=new BufferInputStream(1024*250,100*1024,"video");
  mpegplayInput->open(input->getUrl());
  lmpegplayRun=false;

  mpegplayPlugin->setOutputPlugin(output);

}


void MpgPlugin::resetCounters() {
  lastVideoCnt=1;
  globalPacketCnt=0;
  audioPacketCnt=0;
  videoPacketCnt=0;
}


void MpgPlugin::restartSPlay() {
  splayPlugin=new SplayPlugin();

  if (downSampleFlag) {
    splayPlugin->config("-2","");
  }
  if (monoFlag) {
    splayPlugin->config("-m","");
  }
  // autoplay on after setInputPlugin
  splayPlugin->config("-p","");
  lsplayRun=false;
  splayPlugin->config("-c","");
  splayInput=new BufferInputStream(1024*250,100*1024,"audio");
  splayPlugin->setOutputPlugin(output);
  splayInput->open(input->getUrl());
}


void MpgPlugin::shutDownSPlay() {
  splayInput->close();
  splayPlugin->close();
  delete splayPlugin;
  delete splayInput;
  audioPacketArray->clear();
}


int MpgPlugin::seek(int second) {
  decoderLock();
  int back=false;
  while(lhasLength==false) {
    cout << "waiting for length info"<<endl;
    usleep(100000);
  }


  if (mpegLength == NULL) {
    decoderUnlock();
    return false;
  }
  // we must shudonw the splayPLugin because
  // otherwise it produces bad audio data.
  if (lsplayRun) {
    shutDownSPlay();
    restartSPlay();
    resetCounters();
    audioPacketArray->clear();
  }
  if (lmpegplayRun) {
    shutDownMPEGPlay();
    restartMPEGPlay();
    resetCounters();
  }    
  requiredFillGrade=1;
  output->audioFlush();

  //removeSubPlugins();
  //startSubPlugins();
  lInit=false;


  long pos=mpegLength->getSeekPos(second);
  if (input != NULL) {
    back=input->seek(pos);
  }

  decoderUnlock();
  return back;

}


// here we can config our decoder with special flags
void MpgPlugin::config(char* key, char* value) {
  if (strcmp(key,"-c")==0) {
    lCalcLength=false;
  }
  if (strcmp(key,"-m")==0) {
    monoFlag=true;
  }
  if (strcmp(key,"-2")==0) {
    downSampleFlag=true;
  }
}




void MpgPlugin::get_more_data(Packet* packet) {
  int bytes;
  unsigned char packetID;
  int layer=packet->getSysLayer();
  
  bytes=0;

  if (layer == _PACKET_SYSLAYER) {
    bytes=packet->readNextLayer(packetID,input);
  } else {
    bytes=0x8000;
    packetID=PAKET_ID_VIDEO;
  }

  if (bytes  <= 0) {
    printf ("\n");
    perror("Unexpected read error.");
    return;
  }

  unsigned char* packetBuffer= new unsigned char[bytes];
  input->read((char*)packetBuffer,bytes);





  float avRatio;


  globalPacketCnt++;
  if (packetID == PAKET_ID_AUDIO) {
    // we have an audio paket
    // here we calculate the local av ratio between two audio packets
    // video:43      = lastVideoCnt
    // 0 audio:4       = 0 is globalPacketCnt
    // 1 video:44
    // 2 video:45
    // 3 video:46
    // 4 video:47      = one before this audioPacket
    // 5 audio:5       = current PacketID
    // result -> avRatio=4

    avRatio=globalPacketCnt-lastVideoCnt;
    lastVideoCnt=globalPacketCnt;
    timeStamp->setAVRatioGlobal(avRatio);
    timeStamp->setAudioRatioLocal(0);
  }
  avRatio=timeStamp->getAVRatioGlobal();
  timeStamp->gettimeofday();

  

  /**
     ok now a bit theory.
     If the avRatio gets too high, we loose sync automatically.
     simply because we have 1 audio packet on eg 100 video frames.
     we can not tell if we are sync or not.
     This means if the ratio gets too high >= 6 then we
     must enhance the audio resolution manually.
     We split the audiopacket into virtual packets.
  */

  timeStampVirtual->setAudioPacketNrMinor(0);
  timeStampVirtual->setFloatTimeStamp(packet->getFloatTimeStamp());
  timeStampVirtual->setPTSTimeStamp(packet->getPTSTimeStamp());
  timeStampVirtual->setDTSTimeStamp(packet->getDTSTimeStamp());


  if (packetID==PAKET_ID_VIDEO) {
    videoPacketCnt++;
    timeStamp->setVideoPacketNr(videoPacketCnt); 
    appendToBuffer((char*)packetBuffer,bytes,packetID);

  } else {
    if (packetID==PAKET_ID_AUDIO) {
      audioPacketCnt++;
      timeStamp->setAudioPacketNr(audioPacketCnt);
      appendToBuffer((char*)packetBuffer,bytes,packetID);
    } else {
      printf("unknown packetID:%8x\n",packetID);
    }
  }

}


void MpgPlugin::appendToBuffer(char* ptr,int bytes, unsigned char packetID) {


  timeStampVirtual->gettimeofday();
  timeStampVirtual->setAVRatioGlobal(timeStamp->getAVRatioGlobal());
  timeStampVirtual->setAudioRatioLocal(timeStamp->getAudioRatioLocal());
  timeStampVirtual->setAudioPacketNr(audioPacketCnt);
  timeStampVirtual->setVideoPacketNr(videoPacketCnt); 
  timeStampVirtual->setGlobalPacketNr(videoPacketCnt+audioPacketCnt);


  
  int pos;


  if (packetID==PAKET_ID_VIDEO) {

   
    timeStampVirtual->setEndPTSTimeStamp(0.0);


    if (mpegplayPlugin->getResync()==false) {
      mpegplayInput->insertTimeStamp(timeStampVirtual,bytes);
    }
    mpegplayInput->write(ptr,bytes);
    
    // insert to video
    if (lmpegplayRun == false) {
      lmpegplayRun=true;
      // we have autoplay on, thus after setting input
      // the player starts to decode
      // and maybe block on the input of course
      mpegplayPlugin->setInputPlugin(mpegplayInput);
    }
    // delayed insert!
     



    delete ptr;
  }
  if (packetID==PAKET_ID_AUDIO) {
    // insert to audio
    // delayed insert!
    // we make a delayed insert because
    // and store the end of the audio packet
    // this is later used to check
    // how much time the video frame is in the future


    if (mpegplayPlugin->getResync()==true) {
      delete ptr;
      return;
    }



    audioPacket->setData(ptr);
    audioPacket->setLen(bytes);
    audioPacket->setStreamTimeStamp(timeStampVirtual->getFloatTimeStamp());
    audioPacket->setDTSTimeStamp(timeStampVirtual->getDTSTimeStamp());
    audioPacket->setPTSTimeStamp(timeStampVirtual->getPTSTimeStamp());
    audioPacketArray->insert(audioPacket);

    if (audioPacketArray->getFillgrade()==2) {
      PacketDescription* firstPacket=audioPacketArray->getPacket(1);

      // end is begin of current because AUDIO_PACKET_SIZE==1

      timeStampVirtual->setEndPTSTimeStamp(timeStampVirtual->
					   getPTSTimeStamp());
      timeStampVirtual->setPTSTimeStamp(firstPacket->getPTSTimeStamp());
      timeStampVirtual->setDTSTimeStamp(firstPacket->getDTSTimeStamp());
      timeStampVirtual->setFloatTimeStamp(firstPacket->getStreamTimeStamp());

      splayInput->insertTimeStamp(timeStampVirtual,firstPacket->getLen());
      splayInput->write(firstPacket->getData(),firstPacket->getLen());

      if (lsplayRun == false) {
	lsplayRun=true;
	// we have autoplay on, thus after setting input
	// the player starts to decode
	// and maybe block on the input of course
	splayPlugin->setInputPlugin(splayInput);
      }


      audioPacketArray->forward();
    }
  }
   
     

}



int MpgPlugin::getSongLength() {
  if (mpegLength == NULL) {
    return 0;
  }
  int back=mpegLength->getLength();
  return back;
}
