/*
  nice try of an X11 output plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __VIDEOOUTPUTX11_H
#define __VIDEOOUTPUTX11_H


#include "../outPlugin/picture.h"


#define _PICTURE_ARRAY_SIZE     5

class PictureArray {

  struct Picture* pictureArray[_PICTURE_ARRAY_SIZE];

  struct Picture* past;                /* Past predictive frame.     */
  struct Picture* future;              /* Future predictive frame.   */
  struct Picture* current;             /* Current frame.             */
  
  float picPerSec;

 public:
  PictureArray(int width, int height, int bpp);
  ~PictureArray();

  inline Picture* getPast() {return past;}
  inline Picture* getFuture() {return future;}
  inline Picture* getCurrent() {return current;}


  inline void setPast(Picture* pic) {past=pic;}
  inline void setFuture(Picture* pic) {future=pic;}
  inline void setCurrent(Picture* pic) {current=pic;}

  void forward();

  void setPicturePerSecond(float val);
  float getPicturePerSecond();


 private:
  Picture* getEmptyPicImage();

};
#endif

