/*
  a buffer
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __MPEGPLAYBITWINDOW_H
#define __MPEGPLAYBITWINDOW_H

#include <iostream.h>
#include "packet.h"
#include "util.h"


class MpegPlayBitWindow {

  int size;
  InputStream* input;
  Packet* packet;

 public:
  MpegPlayBitWindow(InputStream* input);
  ~MpegPlayBitWindow();

  void clear();
  int getLength();
  void setLength(int len);
  void setCurrentValue(int value);
  void flushBits(int bits);
  int showBits(int bits);
  int getLayer();

  inline int showBits32() {
    if (bit_offset) {                                         
    return (curBits | (*(buffer+1) >> (32 - bit_offset)));   
    }                                                                     
    return curBits;                                       
  }
  inline void flushBitsDirect(unsigned int bits) {
    bit_offset += bits;       
    if (bit_offset & 0x20) {                                
      bit_offset -= 32;
      bit_offset &= 0x1f;
      buffer++;                                             
      curBits = *buffer;
      curBits <<=bit_offset;
      buf_length--;                                         
    }                                                                   
    else {                                                              
      curBits <<= bits;                                      
    }    
  }
 
  int firstSync();

  int getBits(int bits);
  int hasBytes(int bytes);

  void printChar(int bytes);
  void printInt(int bytes);
  void print();


  int appendToBuffer(unsigned char* ptr,int len);
  int getLinearFree();
  // true if feof() is true and the buffer is emtpy
  int isEof();
  int getSize();
  int getFreeBytes();
  void resetBuffer();
  void updateCurBits();
  void flushByteOffset();
  void appendToBuffer(unsigned int startCode);


  TimeStamp* getCurrentTimeStamp();

 private:
  int get_more_video_data();
  void resizeBuffer(int insertBytes);
  void fillWithIsoEndCode(int bytes);

  unsigned int bit_offset;             /* Bit offset in stream.      */
  unsigned int *buffer;                 /* Pointer to next byte in buffer */
  int buf_length;                       /* Length of remaining buffer.*/
  unsigned int *buf_start;              /* Pointer to buffer start.   */
  int max_buf_length;                   /* Max length of buffer.      */
  unsigned int num_left;                /* from ReadPacket - leftover */
  unsigned int leftover_bytes;          /* from ReadPacket - leftover */
  unsigned int curBits;                 /* current bits               */

};
#endif



