/*
  parses system layer streams.
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __DEMUX_H
#define __DEMUX_H

#include "mpegPlayBitWindow.h"

#define _DEMUX_SYSLAYER            1
#define _DEMUX_NO_SYSLAYER         0
#define _DEMUX_UNKNOWN_SYSLAYER    2

class DeMux {
  
 public:
  DeMux();
  ~DeMux();

  static int next_start_code(MpegPlayBitWindow* bitwindow);
  static int skip_to_start_code(MpegPlayBitWindow* bitwindow,
				unsigned int code);
  // returns the first 4 bytes as an int in cpu byte order

  static unsigned int getStartCode(MpegPlayBitWindow* bitwindow);

  // returns true if code is a valid startcode
  static int isStartCode(unsigned int code);

 private:
  static int find_start_code(MpegPlayBitWindow* bitwindow,int flush);


};


#endif
