/*
  returns inputtype for a given string
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include "inputDetector.h"



static const char *httpstr1="http:";
static const char *cdistr1="cdi:";
static const char *vcdstr1="vcd:";
static const char *filestr1="file:";

static const char *filestrglobal1="/";
static const char *filestrglobal2="./";


InputDetector::InputDetector() {
}


InputDetector::~InputDetector() {
}



int InputDetector::getInputType(const char* url) {
  int back=__INPUT_FILE;

  if (url == NULL) {
    return back;
  }
  int n=strlen(url);
  if (n >= 1) {
    if (strncmp(url,filestrglobal1,1)==0) {
      return __INPUT_FILE;
    }
    if (strncmp(url,filestrglobal2,2)==0) {
      return __INPUT_FILE;
    }    
  }
  if (n >= 4) {
    if (strncmp(url,cdistr1,4)==0) {
      return __INPUT_CDI;
    }
    if (strncmp(url,vcdstr1,4)==0) {
      return __INPUT_CDI;
    }
  }

  if (n >= 5) {
    if (strncmp(url,httpstr1,5)==0) {
      return __INPUT_HTTP;
    }
    if (strncmp(url,filestr1,5)==0) {
      return __INPUT_FILE;
    }   
  }

  return back;

}
